/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.util;

import java.nio.ByteBuffer;
import org.smartboot.socket.DecoderException;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.util.MqttUtil;

public class TopicByteTree {
    public static final TopicByteTree DEFAULT_INSTANCE = new TopicByteTree();
    private static final int MAX_DEPTH = 128;
    private final int depth;
    protected String topicName;
    private int shift = -1;
    private TopicByteTree[] nodes = new TopicByteTree[1];

    public TopicByteTree() {
        this(null);
    }

    private TopicByteTree(TopicByteTree parent) {
        int n = this.depth = parent == null ? 0 : parent.depth + 1;
        if (this.depth > 128) {
            throw new IllegalStateException("maxDepth is 128 , current is " + this.depth);
        }
    }

    public String search(ByteBuffer buffer) {
        int size = MqttCodecUtil.decodeMsbLsb(buffer);
        TopicByteTree topic = this.search(buffer, 0, size, true);
        return topic.getTopicName();
    }

    private TopicByteTree search(ByteBuffer bytes, int offset, int len, boolean cache) {
        Object b;
        int i;
        Object topicByteTree = this;
        while (offset < len && (i = bytes.get() - ((TopicByteTree)topicByteTree).shift) < ((TopicByteTree)topicByteTree).nodes.length && i >= 0 && (b = (Object)((TopicByteTree)topicByteTree).nodes[i]) != null) {
            topicByteTree = b;
            ++offset;
        }
        if (offset == len) {
            if (((TopicByteTree)topicByteTree).topicName == null) {
                byte[] b2 = new byte[len + 2];
                bytes.position(bytes.position() - offset - 2);
                bytes.get(b2);
                ((TopicByteTree)topicByteTree).setTopicName(new String(b2, 2, len));
            }
            return topicByteTree;
        }
        if (cache && ((TopicByteTree)topicByteTree).depth < 128) {
            int p = bytes.position() - 1;
            b = new byte[len];
            bytes.position(p - offset);
            bytes.get((byte[])b);
            bytes.position(p);
            super.addTopic((byte[])b, offset, len);
            return super.search(bytes, offset, len, cache);
        }
        byte[] b3 = new byte[len + 2];
        bytes.position(bytes.position() - offset - 3);
        bytes.get(b3);
        return new VirtualTopicByteTree(new String(b3, 2, len));
    }

    private synchronized TopicByteTree addTopic(byte[] value, int offset, int len) {
        if (offset == len) {
            byte[] b = new byte[len + 2];
            b[0] = (byte)(len >>> 8 & 0xFF);
            b[1] = (byte)(len & 0xFF);
            System.arraycopy(value, 0, b, 2, len);
            this.setTopicName(new String(b, 2, len));
            return this;
        }
        if (this.depth >= 128) {
            return this;
        }
        int b = value[offset++];
        if (this.shift == -1) {
            this.shift = b;
        }
        if (b - this.shift < 0) {
            this.increase(b - this.shift);
        } else {
            this.increase(b + 1 - this.shift);
        }
        TopicByteTree nextTree = this.nodes[b - this.shift];
        if (nextTree == null) {
            TopicByteTree topicByteTree = new TopicByteTree(this);
            this.nodes[b - this.shift] = topicByteTree;
            nextTree = topicByteTree;
        }
        return nextTree.addTopic(value, offset, len);
    }

    private void increase(int size) {
        if (size == 0) {
            size = -1;
        }
        if (size < 0) {
            TopicByteTree[] temp = new TopicByteTree[this.nodes.length - size];
            System.arraycopy(this.nodes, 0, temp, -size, this.nodes.length);
            this.nodes = temp;
            this.shift += size;
        } else if (this.nodes.length < size) {
            TopicByteTree[] temp = new TopicByteTree[size];
            System.arraycopy(this.nodes, 0, temp, 0, this.nodes.length);
            this.nodes = temp;
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    void setTopicName(String topicName) {
        this.topicName = topicName;
        if (MqttUtil.containsTopicWildcards(topicName)) {
            throw new DecoderException("invalid publish topic name: " + topicName + " (contains wildcards)");
        }
    }

    private static class VirtualTopicByteTree
    extends TopicByteTree {
        public VirtualTopicByteTree(String s) {
            super.setTopicName(s);
        }
    }
}

