/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.util;

import java.util.Collection;
import tech.smartboot.mqtt.common.exception.MqttException;
import tech.smartboot.mqtt.common.util.MqttUtil;

public class ValidateUtils {
    private static final Runnable DEFAULT_RUNNABLE = () -> {};

    public static void notBlank(String parameter, String message) {
        ValidateUtils.notBlank(parameter, message, DEFAULT_RUNNABLE);
    }

    public static void notBlank(String parameter, String message, Runnable callback) {
        if (MqttUtil.isBlank(parameter)) {
            ValidateUtils.throwException(message, callback);
        }
    }

    public static void notNull(Object parameter, String message) {
        ValidateUtils.notNull(parameter, message, DEFAULT_RUNNABLE);
    }

    public static void notNull(Object parameter, String message, Runnable catchCallback) {
        if (parameter == null) {
            ValidateUtils.throwException(message, catchCallback);
        }
    }

    public static <E> void notEmpty(Collection<E> collection, String msg) {
        ValidateUtils.notEmpty(collection, msg, DEFAULT_RUNNABLE);
    }

    public static <E> void notEmpty(Collection<E> collection, String msg, Runnable callback) {
        if (collection == null || collection.isEmpty()) {
            ValidateUtils.throwException(msg, callback);
        }
    }

    public static <E> void isTrue(boolean flag, String msg) {
        ValidateUtils.isTrue(flag, msg, DEFAULT_RUNNABLE);
    }

    public static <E> void isTrue(boolean flag, String msg, Runnable callback) {
        if (!flag) {
            ValidateUtils.throwException(msg, callback);
        }
    }

    public static void throwException(String showMsg, Runnable runnable) {
        throw new MqttException(showMsg, runnable);
    }

    public static void throwException(String showMsg) {
        throw new MqttException(showMsg, DEFAULT_RUNNABLE);
    }
}

