package pine.dom

import org.scalajs.dom

object Window {
  def dragEnd: Event[dom.DragEvent] =
    new Event(dom.window.ondragend = _)
  def keyDown: Event[dom.KeyboardEvent] =
    new Event(dom.window.onkeydown = _)
  def dragOver: Event[dom.DragEvent] =
    new Event(dom.window.ondragover = _)
  def keyUp: Event[dom.KeyboardEvent] =
    new Event(dom.window.onkeyup = _)
  def reset: Event[dom.Event] =
    new Event(dom.window.onreset = _)
  def mouseUp: Event[dom.MouseEvent] =
    new Event(dom.window.onmouseup = _)
  def dragStart: Event[dom.DragEvent] =
    new Event(dom.window.ondragstart = _)
  def drag: Event[dom.DragEvent] =
    new Event(dom.window.ondrag = _)
  def mouseOver: Event[dom.MouseEvent] =
    new Event(dom.window.onmouseover = _)
  def dragLeave: Event[dom.DragEvent] =
    new Event(dom.window.ondragleave = _)
  def afterPrint: Event[dom.Event] =
    new Event(dom.window.onafterprint = _)
  def pause: Event[dom.Event] =
    new Event(dom.window.onpause = _)
  def beforePrint: Event[dom.Event] =
    new Event(dom.window.onbeforeprint = _)
  def mouseDown: Event[dom.MouseEvent] =
    new Event(dom.window.onmousedown = _)
  def seeked: Event[dom.Event] =
    new Event(dom.window.onseeked = _)
  def click: Event[dom.MouseEvent] =
    new Event(dom.window.onclick = _)
  def waiting: Event[dom.Event] =
    new Event(dom.window.onwaiting = _)
  def online: Event[dom.Event] =
    new Event(dom.window.ononline = _)
  def durationChange: Event[dom.Event] =
    new Event(dom.window.ondurationchange = _)
  def blur: Event[dom.FocusEvent] =
    new Event(dom.window.onblur = _)
  def emptied: Event[dom.Event] =
    new Event(dom.window.onemptied = _)
  def seeking: Event[dom.Event] =
    new Event(dom.window.onseeking = _)
  def canPlay: Event[dom.Event] =
    new Event(dom.window.oncanplay = _)
  def stalled: Event[dom.Event] =
    new Event(dom.window.onstalled = _)
  def mouseMove: Event[dom.MouseEvent] =
    new Event(dom.window.onmousemove = _)
  def offline: Event[dom.Event] =
    new Event(dom.window.onoffline = _)
  def beforeUnload: Event[dom.BeforeUnloadEvent] =
    new Event(dom.window.onbeforeunload = _)
  def rateChange: Event[dom.Event] =
    new Event(dom.window.onratechange = _)
  def storage: Event[dom.StorageEvent] =
    new Event(dom.window.onstorage = _)
  def loadStart: Event[dom.Event] =
    new Event(dom.window.onloadstart = _)
  def dragEnter: Event[dom.DragEvent] =
    new Event(dom.window.ondragenter = _)
  def submit: Event[dom.Event] =
    new Event(dom.window.onsubmit = _)
  // def progress: DomEvent[js.Any] =
  //   new DomEvent(dom.window.onprogress = _)
  def dblClick: Event[dom.MouseEvent] =
    new Event(dom.window.ondblclick = _)
  def contextMenu: Event[dom.MouseEvent] =
    new Event(dom.window.oncontextmenu = _)
  def change: Event[dom.Event] =
    new Event(dom.window.onchange = _)
  def loadedMetadata: Event[dom.Event] =
    new Event(dom.window.onloadedmetadata = _)
  def play: Event[dom.Event] =
    new Event(dom.window.onplay = _)
  // def error: DomEvent[dom.Event] =
  //   new DomEvent(dom.window.onerror = _)
  def playing: Event[dom.Event] =
    new Event(dom.window.onplaying = _)
  def canPlayThrough: Event[dom.Event] =
    new Event(dom.window.oncanplaythrough = _)
  def abort: Event[dom.UIEvent] =
    new Event(dom.window.onabort = _)
  def readyStateChange: Event[dom.Event] =
    new Event(dom.window.onreadystatechange = _)
  def keyPress: Event[dom.KeyboardEvent] =
    new Event(dom.window.onkeypress = _)
  def loadedData: Event[dom.Event] =
    new Event(dom.window.onloadeddata = _)
  def suspend: Event[dom.Event] =
    new Event(dom.window.onsuspend = _)
  def focus: Event[dom.FocusEvent] =
    new Event(dom.window.onfocus = _)
  def message: Event[dom.MessageEvent] =
    new Event(dom.window.onmessage = _)
  def timeUpdate: Event[dom.Event] =
    new Event(dom.window.ontimeupdate = _)
  def resize: Event[dom.UIEvent] =
    new Event(dom.window.onresize = _)
  def select: Event[dom.UIEvent] =
    new Event(dom.window.onselect = _)
  def drop: Event[dom.DragEvent] =
    new Event(dom.window.ondrop = _)
  def mouseOut: Event[dom.MouseEvent] =
    new Event(dom.window.onmouseout = _)
  def ended: Event[dom.Event] =
    new Event(dom.window.onended = _)
  def hashChange: Event[dom.HashChangeEvent] =
    new Event(dom.window.onhashchange = _)
  def unload: Event[dom.Event] =
    new Event(dom.window.onunload = _)
  def scroll: Event[dom.UIEvent] =
    new Event(dom.window.onscroll = _)
  def mouseWheel: Event[dom.WheelEvent] =
    new Event(dom.window.onmousewheel = _)
  def load: Event[dom.Event] =
    new Event(dom.window.onload = _)
  def volumeChange: Event[dom.Event] =
    new Event(dom.window.onvolumechange = _)
  def input: Event[dom.Event] =
    new Event(dom.window.oninput = _)
  def popState: Event[dom.PopStateEvent] =
    new Event(dom.window.onpopstate = _)
}
