/*
 * Decompiled with CFR 0.152.
 */
package pine;

import java.io.Serializable;
import pine.HtmlEntities$;
import pine.ParseError;
import pine.Reader;
import pine.XmlEntities$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class HtmlHelpers$ {
    public static final HtmlHelpers$ MODULE$ = new HtmlHelpers$();
    private static final Set<String> VoidElements = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"}));
    private static final Set<String> CdataElements;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        CdataElements = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"script", "style"}));
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    public Set<String> VoidElements() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/tim/dev/pine/./src/main/scala/pine/HtmlHelpers.scala: 9");
        }
        return VoidElements;
    }

    public Set<String> CdataElements() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/tim/dev/pine/./src/main/scala/pine/HtmlHelpers.scala: 13");
        }
        return CdataElements;
    }

    public String encodeAttributeValue(Object value) {
        return new StringBuilder(2).append("\"").append(value.toString().replaceAll("&", "&amp;").replaceAll("\"", "&quot;")).append("\"").toString();
    }

    public String decodeAttributeValue(String value) {
        return value.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"");
    }

    public String encodeText(String text, boolean xml) {
        return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(text), (Function1 & Serializable)c -> HtmlHelpers$.$anonfun$encodeText$1(BoxesRunTime.unboxToChar((Object)c)));
    }

    public List<String> parseTokenSet(String value) {
        return value.isEmpty() ? List$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(value), ' ')).toList();
    }

    public String parseHexBinary(String hex) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), hex.length()).by(2).foreach((Function1 & Serializable)i -> HtmlHelpers$.$anonfun$parseHexBinary$1(hex, sb, BoxesRunTime.unboxToInt((Object)i)));
        return sb.toString();
    }

    private String stripLeading(String str, char c) {
        String string;
        if (str.isEmpty()) {
            string = str;
        } else {
            int i = 0;
            while (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), i) == c) {
                ++i;
            }
            string = str.substring(i);
        }
        return string;
    }

    public Option<String> decodeEntity(String e, boolean xml) {
        return e.startsWith("#x0") ? new Some((Object)new String(this.parseHexBinary(this.stripLeading(e.substring(3), '0')))) : (e.startsWith("#") ? new Some((Object)((Object)BoxesRunTime.boxToCharacter((char)((char)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(e.substring(1)))))).toString()) : (e.isEmpty() ? None$.MODULE$ : (xml ? XmlEntities$.MODULE$.entities().get((Object)e) : HtmlEntities$.MODULE$.entities().get((Object)e))));
    }

    public String decodeText(String text, boolean xml) {
        Reader reader = new Reader(text);
        return this.f$1(reader, xml);
    }

    public String encodeAttributes(Map<String, Object> attributes) {
        return ((IterableOnceOps)attributes.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            String string = new StringBuilder(0).append(new StringBuilder(1).append(key).append("=").toString()).append(MODULE$.encodeAttributeValue(value)).toString();
            return string;
        })).mkString(" ");
    }

    public String node(String tagName, Map<String, Object> attributes, List<String> contents, boolean xml) {
        String string;
        String attrs;
        String string2 = attrs = attributes.isEmpty() ? "" : new StringBuilder(1).append(" ").append(this.encodeAttributes(attributes)).toString();
        if (!xml && this.VoidElements().contains((Object)tagName) && contents.isEmpty()) {
            string = new StringBuilder(3).append("<").append(tagName).append(attrs).append("/>").toString();
        } else {
            String children = contents.mkString();
            string = new StringBuilder(5).append("<").append(tagName).append(attrs).append(">").append(children).append("</").append(tagName).append(">").toString();
        }
        return string;
    }

    public boolean identifierCharacter(char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '-' || c == '_' || c == ':';
    }

    public static final /* synthetic */ String $anonfun$encodeText$1(char c) {
        String string;
        char c2 = c;
        switch (c2) {
            case '<': {
                string = "&lt;";
                break;
            }
            case '>': {
                string = "&gt;";
                break;
            }
            case '&': {
                string = "&amp;";
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': {
                string = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
                break;
            }
            default: {
                if (c >= ' ') {
                    string = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
                    break;
                }
                string = "";
                break;
            }
        }
        return string;
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$parseHexBinary$1(String hex$1, scala.collection.mutable.StringBuilder sb$1, int i) {
        String str = hex$1.substring(i, i + 2);
        return sb$1.append((char)Integer.parseInt(str, 16));
    }

    public static final /* synthetic */ boolean $anonfun$decodeText$1(char c) {
        return !RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) && c != '#';
    }

    private final String f$1(Reader reader$1, boolean xml$1) {
        String string;
        Option<String> option = reader$1.collect('&');
        if (None$.MODULE$.equals(option)) {
            string = reader$1.rest();
        } else if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            String prefix = (String)some.value();
            Option<String> option2 = reader$1.collectUntil((Function1<Object, Object>)(Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)HtmlHelpers$.$anonfun$decodeText$1(BoxesRunTime.unboxToChar((Object)c))));
            if (None$.MODULE$.equals(option2)) {
                throw new ParseError("Ambiguous entity");
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String e = (String)some2.value();
                if (!reader$1.prefix(';')) {
                    string2 = new StringBuilder(1).append(prefix).append("&").append(this.f$1(reader$1, xml$1)).toString();
                } else {
                    String ent = (String)this.decodeEntity(e, xml$1).getOrElse((Function0 & Serializable)() -> {
                        throw new ParseError(new StringBuilder(17).append("Invalid entity '").append(e).append("'").toString());
                    });
                    string2 = new StringBuilder(0).append(prefix).append(ent).append(this.f$1(reader$1, xml$1)).toString();
                }
            } else {
                throw new MatchError(option2);
            }
            String string3 = string2;
            string = string3;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private HtmlHelpers$() {
    }
}

