/*
 * Decompiled with CFR 0.152.
 */
package pine.internal;

import java.io.Serializable;
import pine.HtmlHelpers$;
import pine.Node;
import pine.ParseError;
import pine.Reader;
import pine.Tag;
import pine.Text;
import pine.Text$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;

public final class HtmlParser$ {
    public static final HtmlParser$ MODULE$ = new HtmlParser$();

    public Tuple2<String, String> parseAttr(Reader reader) {
        String name = this.identifier(reader);
        String value = reader.prefix('=') ? this.parseAttrValue(reader) : "";
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)value);
    }

    public Map<String, String> parseAttrs(Reader reader) {
        return this.f$1(Predef$.MODULE$.Map().empty(), reader);
    }

    public String rest(Reader reader) {
        return new StringBuilder(5).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(reader.rest()), 20)).append("[...]").toString();
    }

    public Nothing$ expected(Reader reader, String expected) {
        throw new ParseError(new StringBuilder(21).append("Expected '").append(expected).append("', found '").append(this.rest(reader)).append("'").toString());
    }

    public String parseAttrValue(Reader reader) {
        if (!reader.prefix('\"')) {
            throw this.expected(reader, "\"");
        }
        String str = (String)reader.collect('\"').getOrElse((Function0 & Serializable)() -> MODULE$.expected(reader, "\""));
        return HtmlHelpers$.MODULE$.decodeAttributeValue(str);
    }

    public String identifier(Reader reader) {
        String value;
        Some some;
        String string;
        Option<String> option = reader.collectUntil((Function1<Object, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HtmlParser$.$anonfun$identifier$1(BoxesRunTime.unboxToChar((Object)x$2))));
        boolean bl = None$.MODULE$.equals(option) ? true : option instanceof Some && "".equals(string = (String)(some = (Some)option).value());
        if (bl) {
            throw new ParseError(new StringBuilder(29).append("Identifier expected, found '").append(this.rest(reader)).append("'").toString());
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some2 = (Some)option;
        String string2 = value = (String)some2.value();
        return string2;
    }

    public List<Node> parseChildren(Reader reader, String tagName, boolean xml) {
        List list;
        if (!xml && HtmlHelpers$.MODULE$.VoidElements().contains((Object)tagName)) {
            list = List$.MODULE$.empty();
        } else if (!xml && HtmlHelpers$.MODULE$.CdataElements().contains((Object)tagName)) {
            String result = (String)reader.collect(new StringBuilder(3).append("</").append(tagName).append(">").toString()).getOrElse((Function0 & Serializable)() -> MODULE$.expected(reader, new StringBuilder(3).append("</").append(tagName).append(">").toString()));
            list = (List)new .colon.colon((Object)new Text(result), (List)Nil$.MODULE$);
        } else {
            list = this.f$2(List$.MODULE$.empty(), reader, tagName, xml);
        }
        return list;
    }

    public boolean skipComment(Reader reader) {
        boolean bl;
        if (!reader.prefix("<!--")) {
            bl = false;
        } else {
            reader.collect("-->").orElse((Function0 & Serializable)() -> MODULE$.expected(reader, "-->"));
            bl = true;
        }
        return bl;
    }

    public void skipDocType(Reader reader) {
        block0: {
            if (!reader.prefix("<!DOCTYPE")) break block0;
            reader.collect('>').orElse((Function0 & Serializable)() -> MODULE$.expected(reader, ">"));
        }
    }

    public void skipXml(Reader reader) {
        block0: {
            if (!reader.prefix("<?xml")) break block0;
            reader.collect('>').orElse((Function0 & Serializable)() -> MODULE$.expected(reader, ">"));
        }
    }

    public Option<Text> parseCdata(Reader reader) {
        return !reader.prefix("<![CDATA[") ? None$.MODULE$ : reader.collect("]]>").map((Function1)Text$.MODULE$).orElse((Function0 & Serializable)() -> MODULE$.expected(reader, "]]>"));
    }

    public Option<Tag<?>> parseTag(Reader reader, boolean xml) {
        None$ none$;
        if (!reader.prefix("<")) {
            none$ = None$.MODULE$;
        } else {
            List<Node> list;
            String tagName = this.identifier(reader);
            reader.skip((Function1<Object, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$3)))));
            Map<String, String> tagAttrs = this.parseAttrs(reader);
            if (reader.prefix("/>")) {
                list = List$.MODULE$.empty();
            } else if (reader.prefix(">")) {
                list = this.parseChildren(reader, tagName, xml);
            } else {
                throw this.expected(reader, "/>");
            }
            List<Node> tagChildren = list;
            none$ = new Some(new Tag(tagName, tagAttrs, tagChildren));
        }
        return none$;
    }

    public Option<Text> parseText(Reader reader, boolean xml) {
        String text = (String)reader.collectUntil('<').getOrElse((Function0 & Serializable)() -> reader.rest());
        return text.isEmpty() ? None$.MODULE$ : new Some((Object)new Text(HtmlHelpers$.MODULE$.decodeText(text, xml)));
    }

    public Option<Node> parseNode(Reader reader, boolean xml) {
        return (!xml ? None$.MODULE$ : this.parseCdata(reader)).orElse((Function0 & Serializable)() -> MODULE$.parseTag(reader, xml)).orElse((Function0 & Serializable)() -> MODULE$.parseText(reader, xml));
    }

    public Option<Tag<?>> parseRootNode(Reader reader, boolean xml) {
        while (this.skipComment(reader)) {
        }
        return this.parseTag(reader, xml);
    }

    public Tag<Object> fromString(String html, boolean xml) {
        Reader reader = new Reader(html);
        reader.skip((Function1<Object, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$4)))));
        this.skipDocType(reader);
        reader.skip((Function1<Object, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$5)))));
        if (xml) {
            this.skipXml(reader);
        }
        reader.skip((Function1<Object, Object>)(Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$6)))));
        return (Tag)this.parseRootNode(reader, xml).getOrElse((Function0 & Serializable)() -> {
            throw new ParseError("Invalid input");
        });
    }

    private final Map f$1(Map acc, Reader reader$1) {
        while (!reader$1.lookahead("/>") && !reader$1.lookahead(">")) {
            Tuple2<String, String> attr = this.parseAttr(reader$1);
            reader$1.skip((Function1<Object, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$1)))));
            acc = (Map)acc.$plus(attr);
        }
        return acc;
    }

    public static final /* synthetic */ boolean $anonfun$identifier$1(char x$2) {
        return !HtmlHelpers$.MODULE$.identifierCharacter(x$2);
    }

    private final List f$2(List nodes, Reader reader$3, String tagName$1, boolean xml$1) {
        List list;
        block2: {
            block3: {
                Option<Node> option;
                while (true) {
                    if (reader$3.prefix(new StringBuilder(3).append("</").append(tagName$1).append(">").toString())) {
                        list = nodes;
                        break block2;
                    }
                    if (this.skipComment(reader$3)) continue;
                    option = this.parseNode(reader$3, xml$1);
                    if (None$.MODULE$.equals(option)) break block3;
                    if (!(option instanceof Some)) break;
                    Some some = (Some)option;
                    Node t = (Node)some.value();
                    nodes = (List)nodes.$colon$plus((Object)t);
                }
                throw new MatchError(option);
            }
            List list2 = nodes;
            list = list2;
        }
        return list;
    }

    private HtmlParser$() {
    }
}

