/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleIterable;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.DoubleColumnUtils;
import tech.tablesaw.filtering.DoubleBiPredicate;
import tech.tablesaw.filtering.DoublePredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.Selection;
import tech.tablesaw.util.Stats;

public class DoubleColumn
extends AbstractColumn
implements DoubleIterable,
NumericColumn {
    public static final double MISSING_VALUE = (Double)ColumnType.DOUBLE.getMissingValue();
    private static final int BYTE_SIZE = 8;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static int DEFAULT_ARRAY_SIZE = 128;
    private DoubleComparator reverseDoubleComparator = new DoubleComparator(){

        public int compare(Double o2, Double o1) {
            return o1 < o2 ? -1 : (o1.equals(o2) ? 0 : 1);
        }

        public int compare(double o2, double o1) {
            return Double.compare(o1, o2);
        }
    };
    private DoubleArrayList data;
    private final IntComparator comparator = new IntComparator(){

        public int compare(Integer r1, Integer r2) {
            double f1 = DoubleColumn.this.data.getDouble(r1.intValue());
            double f2 = DoubleColumn.this.data.getDouble(r2.intValue());
            return Double.compare(f1, f2);
        }

        public int compare(int r1, int r2) {
            double f1 = DoubleColumn.this.data.getDouble(r1);
            double f2 = DoubleColumn.this.data.getDouble(r2);
            return Double.compare(f1, f2);
        }
    };

    public DoubleColumn(String name) {
        this(name, new DoubleArrayList(DEFAULT_ARRAY_SIZE));
    }

    public DoubleColumn(String name, int initialSize) {
        this(name, new DoubleArrayList(initialSize));
    }

    public DoubleColumn(String name, double[] arr) {
        this(name, new DoubleArrayList(arr));
    }

    private DoubleColumn(String name, DoubleArrayList data) {
        super(name);
        this.data = data;
    }

    public DoubleColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new DoubleArrayList(metadata.getSize());
    }

    public static double convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Double.parseDouble(matcher.replaceAll(""));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Table summary() {
        return this.stats().asTable();
    }

    public Stats stats() {
        return Stats.create(this);
    }

    @Override
    public int countUnique() {
        DoubleOpenHashSet doubles = new DoubleOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            doubles.add(this.data.getDouble(i));
        }
        return doubles.size();
    }

    public DoubleArrayList top(int n) {
        DoubleArrayList top = new DoubleArrayList();
        double[] values = this.data.toDoubleArray();
        DoubleArrays.parallelQuickSort((double[])values, (DoubleComparator)this.reverseDoubleComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return top;
    }

    public DoubleArrayList bottom(int n) {
        DoubleArrayList bottom = new DoubleArrayList();
        double[] values = this.data.toDoubleArray();
        DoubleArrays.parallelQuickSort((double[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return bottom;
    }

    @Override
    public DoubleColumn unique() {
        DoubleOpenHashSet doubles = new DoubleOpenHashSet();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            doubles.add(this.data.getDouble(i2));
        }
        DoubleColumn column = new DoubleColumn(this.name() + " Unique values", doubles.size());
        doubles.forEach(i -> column.append(i));
        return column;
    }

    public DoubleArrayList data() {
        return this.data;
    }

    @Override
    public ColumnType type() {
        return ColumnType.DOUBLE;
    }

    public double firstElement() {
        if (this.size() > 0) {
            return this.data.getDouble(0);
        }
        return MISSING_VALUE;
    }

    public double sum() {
        return AggregateFunctions.sum.agg(this);
    }

    @Override
    public double product() {
        return AggregateFunctions.product.agg(this);
    }

    @Override
    public double mean() {
        return AggregateFunctions.mean.agg(this);
    }

    @Override
    public double median() {
        return AggregateFunctions.median.agg(this);
    }

    @Override
    public double quartile1() {
        return AggregateFunctions.quartile1.agg(this);
    }

    @Override
    public double quartile3() {
        return AggregateFunctions.quartile3.agg(this);
    }

    @Override
    public double percentile(double percentile) {
        return AggregateFunctions.percentile(this.toDoubleArray(), percentile);
    }

    @Override
    public double range() {
        return AggregateFunctions.range.agg(this);
    }

    @Override
    public double max() {
        return AggregateFunctions.max.agg(this);
    }

    @Override
    public double min() {
        return AggregateFunctions.min.agg(this);
    }

    @Override
    public double variance() {
        return AggregateFunctions.variance.agg(this);
    }

    @Override
    public double populationVariance() {
        return AggregateFunctions.populationVariance.agg(this);
    }

    @Override
    public double standardDeviation() {
        return AggregateFunctions.stdDev.agg(this);
    }

    @Override
    public double sumOfLogs() {
        return AggregateFunctions.sumOfLogs.agg(this);
    }

    @Override
    public double sumOfSquares() {
        return AggregateFunctions.sumOfSquares.agg(this);
    }

    @Override
    public double geometricMean() {
        return AggregateFunctions.geometricMean.agg(this);
    }

    @Override
    public double quadraticMean() {
        return AggregateFunctions.quadraticMean.agg(this);
    }

    @Override
    public double kurtosis() {
        return AggregateFunctions.kurtosis.agg(this);
    }

    @Override
    public double skewness() {
        return AggregateFunctions.skewness.agg(this);
    }

    public void append(float f) {
        this.data.add((double)f);
    }

    public void append(double d) {
        this.data.add(d);
    }

    public Selection isLessThan(double f) {
        return this.select(DoubleColumnUtils.isLessThan, f);
    }

    @Override
    public Selection isMissing() {
        return this.select(DoubleColumnUtils.isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(DoubleColumnUtils.isNotMissing);
    }

    public Selection isGreaterThan(double f) {
        return this.select(DoubleColumnUtils.isGreaterThan, f);
    }

    public Selection isGreaterThanOrEqualTo(double f) {
        return this.select(DoubleColumnUtils.isGreaterThanOrEqualTo, f);
    }

    public Selection isLessThanOrEqualTo(double f) {
        return this.select(DoubleColumnUtils.isLessThanOrEqualTo, f);
    }

    public Selection isNotEqualTo(double d) {
        return this.select(DoubleColumnUtils.isNotEqualTo, d);
    }

    public Selection isEqualTo(double d) {
        return this.select(DoubleColumnUtils.isEqualTo, d);
    }

    public Selection isEqualTo(DoubleColumn d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        DoubleIterator doubleIterator = d.iterator();
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double doubles = (Double)doubleListIterator.next();
            if (doubles == doubleIterator.nextDouble()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public String getString(int row) {
        double value = this.data.getDouble(row);
        if (Double.isNaN(value)) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public DoubleColumn emptyCopy() {
        DoubleColumn column = new DoubleColumn(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DoubleColumn emptyCopy(int rowSize) {
        DoubleColumn column = new DoubleColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data = new DoubleArrayList(DEFAULT_ARRAY_SIZE);
    }

    @Override
    public DoubleColumn copy() {
        DoubleColumn column = new DoubleColumn(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        DoubleArrays.parallelQuickSort((double[])this.data.elements(), (DoubleComparator)this.reverseDoubleComparator);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            double f = this.get(i);
            if (!Double.isNaN(f)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void appendCell(String object) {
        try {
            this.append(DoubleColumn.convert(object));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(this.name() + ": " + e.getMessage());
        }
    }

    public DoubleColumn logN() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[logN]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(Math.log(value));
        }
        return newColumn;
    }

    public DoubleColumn log10() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[log10]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(Math.log10(value));
        }
        return newColumn;
    }

    public DoubleColumn log1p() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[1og1p]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(Math.log1p(value));
        }
        return newColumn;
    }

    public DoubleColumn round() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[rounded]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(Math.round(value));
        }
        return newColumn;
    }

    public DoubleColumn abs() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[abs]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(Math.abs(value));
        }
        return newColumn;
    }

    public DoubleColumn square() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[sq]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(value * value);
        }
        return newColumn;
    }

    public DoubleColumn sqrt() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[sqrt]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(Math.sqrt(value));
        }
        return newColumn;
    }

    public DoubleColumn cubeRoot() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[cbrt]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(Math.cbrt(value));
        }
        return newColumn;
    }

    public DoubleColumn cube() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[cb]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(value * value * value);
        }
        return newColumn;
    }

    public DoubleColumn remainder(DoubleColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " % " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) % column2.get(r));
        }
        return result;
    }

    public DoubleColumn add(DoubleColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " + " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.add(this.get(r), column2.get(r)));
        }
        return result;
    }

    public DoubleColumn add(double value) {
        DoubleColumn result = new DoubleColumn(this.name() + " + " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.add(this.get(r), value));
        }
        return result;
    }

    public DoubleColumn subtract(double value) {
        DoubleColumn result = new DoubleColumn(this.name() + " - " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.subtract(this.get(r), value));
        }
        return result;
    }

    public DoubleColumn subtract(DoubleColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " - " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.subtract(this.get(r), column2.get(r)));
        }
        return result;
    }

    public DoubleColumn multiply(DoubleColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * column2.get(r));
        }
        return result;
    }

    public DoubleColumn multiply(IntColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * (double)column2.get(r));
        }
        return result;
    }

    public DoubleColumn multiply(LongColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * (double)column2.get(r));
        }
        return result;
    }

    public DoubleColumn multiply(ShortColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * (double)column2.get(r));
        }
        return result;
    }

    public DoubleColumn divide(DoubleColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / column2.get(r));
        }
        return result;
    }

    public DoubleColumn divide(IntColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / (double)column2.get(r));
        }
        return result;
    }

    public DoubleColumn divide(LongColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / (double)column2.get(r));
        }
        return result;
    }

    public DoubleColumn divide(ShortColumn column2) {
        DoubleColumn result = new DoubleColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / (double)column2.get(r));
        }
        return result;
    }

    public DoubleColumn neg() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[neg]", this.size());
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double value = (Double)doubleIterator.next();
            newColumn.append(value * -1.0);
        }
        return newColumn;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public double get(int index) {
        return this.data.getDouble(index);
    }

    @Override
    public float getFloat(int index) {
        return (float)this.data.getDouble(index);
    }

    public double getDouble(int index) {
        return this.data.getDouble(index);
    }

    public void set(int r, double value) {
        this.data.set(r, value);
    }

    Selection isCloseTo(float target) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double f = (Double)doubleListIterator.next();
            if (Double.compare(f, target) == 0) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    Selection isCloseTo(double target) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double f = (Double)doubleListIterator.next();
            if (Double.compare(f, 0.0) == 0) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isPositive() {
        return this.select(DoubleColumnUtils.isPositive);
    }

    public Selection isZero() {
        return this.select(DoubleColumnUtils.isZero);
    }

    public Selection isNegative() {
        return this.select(DoubleColumnUtils.isNegative);
    }

    public Selection isNonNegative() {
        return this.select(DoubleColumnUtils.isNonNegative);
    }

    @Override
    public double[] toDoubleArray() {
        double[] output = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getDouble(i);
        }
        return output;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double aData = (Double)doubleListIterator.next();
            builder.append(String.valueOf(aData));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "Double column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DoubleColumn doubleColumn = (DoubleColumn)column;
        for (int i = 0; i < doubleColumn.size(); ++i) {
            this.append(doubleColumn.get(i));
        }
    }

    public DoubleIterator iterator() {
        return this.data.iterator();
    }

    public Selection select(DoublePredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            double next = this.data.getDouble(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public Selection select(DoubleBiPredicate predicate, double value) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            double next = this.data.getDouble(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    DoubleSet asSet() {
        return new DoubleOpenHashSet((DoubleCollection)this.data);
    }

    public boolean contains(double value) {
        return this.data.contains(value);
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putDouble(this.get(rowNumber)).array();
    }

    @Override
    public DoubleColumn difference() {
        DoubleColumn returnValue = new DoubleColumn(this.name(), this.size());
        returnValue.append(MISSING_VALUE);
        for (int current = 0; current < this.size(); ++current) {
            if (current + 1 >= this.size()) continue;
            double currentValue = this.get(current);
            double nextValue = this.get(current + 1);
            if (Double.isNaN(currentValue) || Double.isNaN(nextValue)) {
                returnValue.append(MISSING_VALUE);
                continue;
            }
            returnValue.append(nextValue - currentValue);
        }
        return returnValue;
    }

    private double add(double val1, double val2) {
        if (val1 == MISSING_VALUE || val2 == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return val1 + val2;
    }

    private double subtract(double val1, double val2) {
        if (val1 == MISSING_VALUE || val2 == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return val1 - val2;
    }
}

