/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import it.unimi.dsi.fastutil.ints.IntIterator;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.columns.IntColumnUtils;

public interface IntMapUtils
extends IntColumnUtils {
    default public IntColumn plus(IntColumn ... columns) {
        String nString = this.names(columns);
        String name = String.format("sum(%s)", nString);
        IntColumn newColumn = new IntColumn(name);
        for (int r = 0; r < columns[0].size(); ++r) {
            int result = 0;
            for (IntColumn column : columns) {
                result += column.get(r);
            }
            newColumn.append(result);
        }
        return newColumn;
    }

    default public IntColumn plus(int value) {
        String name = this.name() + " + " + value;
        IntColumn newColumn = new IntColumn(name);
        for (int r = 0; r < this.size(); ++r) {
            newColumn.append(this.get(r) + value);
        }
        return newColumn;
    }

    default public IntColumn multiply(int value) {
        String name = this.name() + " * " + value;
        IntColumn newColumn = new IntColumn(name);
        for (int r = 0; r < this.size(); ++r) {
            int result = this.get(r) == IntColumn.MISSING_VALUE ? IntColumn.MISSING_VALUE : this.get(r) * value;
            newColumn.append(result);
        }
        return newColumn;
    }

    default public FloatColumn multiply(double value) {
        String name = this.name() + " * " + value;
        FloatColumn newColumn = new FloatColumn(name);
        for (int r = 0; r < this.size(); ++r) {
            newColumn.append((float)this.get(r) * (float)value);
        }
        return newColumn;
    }

    default public FloatColumn divide(int value) {
        String name = this.name() + " / " + value;
        FloatColumn newColumn = new FloatColumn(name);
        for (int r = 0; r < this.size(); ++r) {
            newColumn.append((float)this.get(r) / ((float)value * 1.0f));
        }
        return newColumn;
    }

    default public FloatColumn divide(double value) {
        String name = this.name() + " / " + value;
        FloatColumn newColumn = new FloatColumn(name);
        for (int r = 0; r < this.size(); ++r) {
            newColumn.append((double)this.get(r) / value);
        }
        return newColumn;
    }

    default public FloatColumn divide(IntColumn divisor) {
        String name = this.name() + " / " + divisor.name();
        FloatColumn newColumn = new FloatColumn(name);
        for (int r = 0; r < this.size(); ++r) {
            newColumn.append((float)this.get(r) / ((float)divisor.get(r) * 1.0f));
        }
        return newColumn;
    }

    default public String names(IntColumn[] columns) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (IntColumn column : columns) {
            builder.append(column.name());
            if (count < columns.length - 1) {
                builder.append(", ");
            }
            ++count;
        }
        return builder.toString();
    }

    default public FloatColumn asRatio() {
        FloatColumn pctColumn = new FloatColumn(this.name() + " percents");
        float total = this.sum();
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int next = (Integer)intIterator.next();
            if (total != 0.0f) {
                pctColumn.append((float)next / total);
                continue;
            }
            pctColumn.append(FloatColumn.MISSING_VALUE);
        }
        return pctColumn;
    }

    default public FloatColumn asPercent() {
        FloatColumn pctColumn = new FloatColumn(this.name() + " percents");
        float total = this.sum();
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int next = (Integer)intIterator.next();
            if (total != 0.0f) {
                pctColumn.append((float)next / total * 100.0f);
                continue;
            }
            pctColumn.append(FloatColumn.MISSING_VALUE);
        }
        return pctColumn;
    }

    public long sum();

    public int get(int var1);

    default public IntColumn subtract(int value) {
        IntColumn result = new IntColumn(this.name() + " - " + value);
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) - value);
        }
        return result;
    }
}

