/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.splitting.dates;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.function.Function;
import tech.tablesaw.columns.packeddata.PackedLocalDate;
import tech.tablesaw.splitting.dates.LocalDateSplitter;

public class SplitUtils {
    public static LocalDateSplitter byYear = PackedLocalDate::getYear;
    public static LocalDateSplitter byMonth = PackedLocalDate::getMonthValue;
    public static LocalDateSplitter byDayOfMonth = PackedLocalDate::getDayOfMonth;
    public static LocalDateSplitter byDayOfYear = PackedLocalDate::getDayOfYear;
    public static LocalDateSplitter byDayOfWeek = packedLocalDate -> PackedLocalDate.getDayOfWeek(packedLocalDate).getValue();
    public static LocalDateSplitter byQuarter = PackedLocalDate::getQuarter;
    public static Function<Comparable<?>, Object> byWeek = comparable -> {
        if (comparable instanceof LocalDate) {
            return ((LocalDate)comparable).get(ChronoField.ALIGNED_WEEK_OF_YEAR);
        }
        if (comparable instanceof LocalDateTime) {
            return ((LocalDateTime)comparable).get(ChronoField.ALIGNED_WEEK_OF_YEAR);
        }
        throw new IllegalArgumentException("Date function called on non-date column");
    };
    public static Function<Comparable<?>, Object> byHour = comparable -> {
        if (comparable instanceof LocalDateTime) {
            return ((LocalDateTime)comparable).get(ChronoField.HOUR_OF_DAY);
        }
        throw new IllegalArgumentException("Time function called on non-time column");
    };
    public static Function<Comparable<?>, Object> bySecondOfMinute = comparable -> {
        if (comparable instanceof LocalDateTime) {
            return ((LocalDateTime)comparable).get(ChronoField.SECOND_OF_MINUTE);
        }
        throw new IllegalArgumentException("Time function called on non-time column");
    };
    public static Function<Comparable<?>, Object> bySecondOfDay = comparable -> {
        if (comparable instanceof LocalDateTime) {
            return ((LocalDateTime)comparable).get(ChronoField.SECOND_OF_DAY);
        }
        throw new IllegalArgumentException("Time function called on non-time column");
    };
    public static Function<Comparable<?>, Object> byMinuteOfHour = comparable -> {
        if (comparable instanceof LocalDateTime) {
            return ((LocalDateTime)comparable).get(ChronoField.MINUTE_OF_HOUR);
        }
        throw new IllegalArgumentException("Time function called on non-time column");
    };
    public static Function<Comparable<?>, Object> byMinuteOfDay = comparable -> {
        if (comparable instanceof LocalDateTime) {
            return ((LocalDateTime)comparable).get(ChronoField.MINUTE_OF_HOUR);
        }
        throw new IllegalArgumentException("Time function called on non-time column");
    };
}

