/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import com.google.common.collect.Lists;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.io.ReadOptions;

public class FloatParser
extends AbstractColumnParser<Float> {
    public FloatParser(ColumnType columnType) {
        super(columnType);
    }

    public FloatParser(FloatColumnType columnType, ReadOptions readOptions) {
        super(columnType);
        if (readOptions.missingValueIndicator() != null) {
            this.missingValueStrings = Lists.newArrayList((Object[])new String[]{readOptions.missingValueIndicator()});
        }
    }

    @Override
    public boolean canParse(String s) {
        if (this.isMissing(s)) {
            return true;
        }
        try {
            Float.parseFloat(AbstractColumnParser.remove(s, ','));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Float parse(String s) {
        return Float.valueOf(this.parseFloat(s));
    }

    @Override
    public float parseFloat(String s) {
        if (this.isMissing(s)) {
            return FloatColumnType.missingValueIndicator();
        }
        return Float.parseFloat(AbstractColumnParser.remove(s, ','));
    }
}

