/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;

public class ReaderRegistry {
    private final Map<String, DataReader<?>> optionTypesRegistry = new HashMap();
    private final Map<String, DataReader<?>> extensionsRegistry = new HashMap();
    private final Map<String, DataReader<?>> mimeTypesRegistry = new HashMap();

    public void registerOptions(Class<? extends ReadOptions> optionsType, DataReader<?> reader) {
        this.optionTypesRegistry.put(optionsType.getCanonicalName(), reader);
    }

    public void registerExtension(String extension, DataReader<?> reader) {
        this.extensionsRegistry.put(extension, reader);
    }

    public void registerMimeType(String mimeType, DataReader<?> reader) {
        this.mimeTypesRegistry.put(mimeType, reader);
    }

    public <T extends ReadOptions> DataReader<T> getReaderForOptions(T options) {
        return this.optionTypesRegistry.get(options.getClass().getCanonicalName());
    }

    public DataReader<?> getReaderForExtension(String extension) {
        return this.extensionsRegistry.get(extension);
    }

    public DataReader<?> getReaderForMimeType(String mimeType) {
        return this.mimeTypesRegistry.get(mimeType);
    }
}

