/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Paths;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.WriteOptions;

public class CsvWriteOptions
extends WriteOptions {
    private final boolean header;
    private final char separator;
    private final char quotechar;
    private final char escapechar;
    private final String lineEnd;

    private CsvWriteOptions(Builder builder) {
        super(builder);
        this.header = builder.header;
        this.separator = builder.separator;
        this.quotechar = builder.quoteChar;
        this.escapechar = builder.escapeChar;
        this.lineEnd = builder.lineEnd;
    }

    public boolean header() {
        return this.header;
    }

    public char separator() {
        return this.separator;
    }

    public char escapeChar() {
        return this.escapechar;
    }

    public char quoteChar() {
        return this.quotechar;
    }

    public String lineEnd() {
        return this.lineEnd;
    }

    public static Builder builder(Destination dest) {
        return new Builder(dest);
    }

    public static Builder builder(OutputStream dest) {
        return new Builder(dest);
    }

    public static Builder builder(Writer dest) {
        return new Builder(dest);
    }

    public static Builder builder(File dest) throws IOException {
        return new Builder(dest);
    }

    public static Builder builder(String fileName) throws IOException {
        return CsvWriteOptions.builder(new File(fileName));
    }

    public static class Builder
    extends WriteOptions.Builder {
        private boolean header = true;
        private char separator = (char)44;
        private String lineEnd = System.lineSeparator();
        private char escapeChar = (char)92;
        private char quoteChar = (char)34;

        protected Builder(String fileName) throws IOException {
            super(Paths.get(fileName, new String[0]).toFile());
        }

        protected Builder(Destination dest) {
            super(dest);
        }

        protected Builder(File file) throws IOException {
            super(file);
        }

        protected Builder(Writer writer) {
            super(writer);
        }

        protected Builder(OutputStream stream) {
            super(stream);
        }

        public Builder separator(char separator) {
            this.separator = separator;
            return this;
        }

        public Builder quoteChar(char quoteChar) {
            this.quoteChar = quoteChar;
            return this;
        }

        public Builder escapeChar(char escapeChar) {
            this.escapeChar = escapeChar;
            return this;
        }

        public Builder lineEnd(String lineEnd) {
            this.lineEnd = lineEnd;
            return this;
        }

        public Builder header(boolean header) {
            this.header = header;
            return this;
        }

        public CsvWriteOptions build() {
            return new CsvWriteOptions(this);
        }
    }
}

