/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.sorting;

import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Iterator;
import java.util.Map;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.sorting.Sort;
import tech.tablesaw.sorting.comparators.IntComparatorChain;
import tech.tablesaw.sorting.comparators.ReversingIntComparator;

public class SortUtils {
    public static IntComparatorChain getChain(Table table, Sort key) {
        Iterator<Map.Entry<String, Sort.Order>> entries = key.iterator();
        Map.Entry<String, Sort.Order> sort = entries.next();
        Column<?> column = table.column(sort.getKey());
        IntComparator comparator = SortUtils.rowComparator(column, sort.getValue());
        IntComparatorChain chain = new IntComparatorChain(comparator);
        while (entries.hasNext()) {
            sort = entries.next();
            chain.addComparator(SortUtils.rowComparator(table.column(sort.getKey()), sort.getValue()));
        }
        return chain;
    }

    public static IntComparator rowComparator(Column<?> column, Sort.Order order) {
        IntComparator rowComparator = column.rowComparator();
        if (order == Sort.Order.DESCEND) {
            return ReversingIntComparator.reverse(rowComparator);
        }
        return rowComparator;
    }

    public static IntComparator getComparator(Table table, Sort key) {
        Iterator<Map.Entry<String, Sort.Order>> entries = key.iterator();
        Map.Entry<String, Sort.Order> sort = entries.next();
        Column<?> column = table.column(sort.getKey());
        return SortUtils.rowComparator(column, sort.getValue());
    }
}

