/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.util.StringUtils;

public class RollingColumn {
    protected final Column<?> column;
    protected final int window;

    public RollingColumn(Column<?> column, int window) {
        this.column = column;
        this.window = window;
    }

    protected String generateNewColumnName(AggregateFunction<?, ?> function) {
        boolean useSpaces = this.column.name().matches("\\s+");
        String separator = useSpaces ? " " : "";
        return this.column.name() + separator + (useSpaces ? function.functionName() : StringUtils.capitalize(function.functionName())) + separator + this.window;
    }

    public <INCOL extends Column<?>, OUT> Column<?> calc(AggregateFunction<INCOL, OUT> function) {
        Column<?> result = function.returnType().create(this.generateNewColumnName(function));
        for (int i = 0; i < this.window - 1; ++i) {
            result.appendMissing();
        }
        for (int origColIndex = 0; origColIndex < this.column.size() - this.window + 1; ++origColIndex) {
            BitmapBackedSelection selection = new BitmapBackedSelection();
            selection.addRange(origColIndex, origColIndex + this.window);
            Column<?> subsetCol = this.column.subset(selection.toArray());
            OUT answer = function.summarize(subsetCol);
            if (answer instanceof Number) {
                Number number = (Number)answer;
                ((DoubleColumn)result).append(number.doubleValue());
                continue;
            }
            result.appendObj(answer);
        }
        return result;
    }
}

