/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import java.util.function.BiPredicate;
import java.util.function.DoublePredicate;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.columns.numbers.NumberPredicates;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface NumberFilters {
    public Selection eval(DoublePredicate var1);

    public Selection eval(BiPredicate<Number, Number> var1, Number var2);

    default public Selection isEqualTo(double d) {
        return this.eval(NumberPredicates.isEqualTo(d));
    }

    default public Selection isNotEqualTo(double d) {
        return this.eval(NumberPredicates.isNotEqualTo(d));
    }

    default public Selection isBetweenExclusive(double start, double end) {
        return this.eval(NumberPredicates.isBetweenExclusive(start, end));
    }

    default public Selection isBetweenInclusive(double start, double end) {
        return this.eval(NumberPredicates.isBetweenInclusive(start, end));
    }

    default public Selection isGreaterThan(double f) {
        return this.eval(NumberPredicates.isGreaterThan(f));
    }

    default public Selection isGreaterThanOrEqualTo(double f) {
        return this.eval(NumberPredicates.isGreaterThanOrEqualTo(f));
    }

    default public Selection isLessThan(double f) {
        return this.eval(NumberPredicates.isLessThan(f));
    }

    default public Selection isLessThanOrEqualTo(double f) {
        return this.eval(NumberPredicates.isLessThanOrEqualTo(f));
    }

    public Selection isIn(Number ... var1);

    public Selection isIn(double ... var1);

    public Selection isNotIn(Number ... var1);

    public Selection isNotIn(double ... var1);

    default public Selection isZero() {
        return this.eval(NumberPredicates.isZero);
    }

    default public Selection isPositive() {
        return this.eval(NumberPredicates.isPositive);
    }

    default public Selection isNegative() {
        return this.eval(NumberPredicates.isNegative);
    }

    default public Selection isNonNegative() {
        return this.eval(NumberPredicates.isNonNegative);
    }

    default public Selection isCloseTo(Number target, Number margin) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            double targetValue = target.doubleValue();
            double marginValue = margin.doubleValue();
            double val = this.getDouble(i);
            if (!(val > targetValue - marginValue) || !(val < targetValue + marginValue)) continue;
            results.add(i);
        }
        return results;
    }

    public Selection isMissing();

    public Selection isNotMissing();

    default public Selection isGreaterThan(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getDouble(i) > d.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }

    default public Selection isGreaterThanOrEqualTo(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getDouble(i) >= d.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }

    default public Selection isEqualTo(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getDouble(i) != d.getDouble(i)) continue;
            results.add(i);
        }
        return results;
    }

    public int size();

    public double getDouble(int var1);

    default public Selection isNotEqualTo(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getDouble(i) == d.getDouble(i)) continue;
            results.add(i);
        }
        return results;
    }

    default public Selection isLessThan(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getDouble(i) < d.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }

    default public Selection isLessThanOrEqualTo(NumericColumn<?> d) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getDouble(i) <= d.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }
}

