/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class SqlResultSetReader {
    private static final Map<Integer, ColumnType> SQL_TYPE_TO_TABLESAW_TYPE = SqlResultSetReader.initializeMap();

    private static Map<Integer, ColumnType> initializeMap() {
        return new HashMap<Integer, ColumnType>((Map<Integer, ColumnType>)new ImmutableMap.Builder().put((Object)-2, (Object)ColumnType.BOOLEAN).put((Object)16, (Object)ColumnType.BOOLEAN).put((Object)-7, (Object)ColumnType.BOOLEAN).put((Object)91, (Object)ColumnType.LOCAL_DATE).put((Object)92, (Object)ColumnType.LOCAL_TIME).put((Object)93, (Object)ColumnType.INSTANT).put((Object)3, (Object)ColumnType.DOUBLE).put((Object)8, (Object)ColumnType.DOUBLE).put((Object)6, (Object)ColumnType.DOUBLE).put((Object)2, (Object)ColumnType.DOUBLE).put((Object)7, (Object)ColumnType.FLOAT).put((Object)4, (Object)ColumnType.INTEGER).put((Object)5, (Object)ColumnType.SHORT).put((Object)-6, (Object)ColumnType.SHORT).put((Object)-5, (Object)ColumnType.LONG).put((Object)1, (Object)ColumnType.STRING).put((Object)-15, (Object)ColumnType.STRING).put((Object)-9, (Object)ColumnType.STRING).put((Object)12, (Object)ColumnType.STRING).put((Object)-1, (Object)ColumnType.TEXT).put((Object)-16, (Object)ColumnType.TEXT).build());
    }

    public static void mapJdbcTypeToColumnType(Integer jdbc, ColumnType columnType) {
        SQL_TYPE_TO_TABLESAW_TYPE.put(jdbc, columnType);
    }

    public static Table read(ResultSet resultSet) throws SQLException {
        int i;
        ResultSetMetaData metaData = resultSet.getMetaData();
        Table table = Table.create();
        for (i = 1; i <= metaData.getColumnCount(); ++i) {
            ColumnType type = SqlResultSetReader.getColumnType(metaData.getColumnType(i), metaData.getScale(i), metaData.getPrecision(i));
            Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"No column type found for %s as specified for column %s", (int)metaData.getColumnType(i), (Object)metaData.getColumnName(i));
            Column<?> newColumn = type.create(metaData.getColumnName(i));
            table.addColumns(new Column[]{newColumn});
        }
        while (resultSet.next()) {
            for (i = 1; i <= metaData.getColumnCount(); ++i) {
                Column<?> column = table.column(i - 1);
                if (column instanceof ShortColumn) {
                    column.appendObj(resultSet.getShort(i));
                    continue;
                }
                if (column instanceof IntColumn) {
                    column.appendObj(resultSet.getInt(i));
                    continue;
                }
                if (column instanceof LongColumn) {
                    column.appendObj(resultSet.getLong(i));
                    continue;
                }
                if (column instanceof FloatColumn) {
                    column.appendObj(Float.valueOf(resultSet.getFloat(i)));
                    continue;
                }
                if (column instanceof DoubleColumn) {
                    column.appendObj(resultSet.getDouble(i));
                    continue;
                }
                column.appendObj(resultSet.getObject(i));
            }
        }
        return table;
    }

    protected static ColumnType getColumnType(int columnType, int scale, int precision) {
        ColumnType type = SQL_TYPE_TO_TABLESAW_TYPE.get(columnType);
        if (columnType == 2 || columnType == 3) {
            if (scale == 0) {
                if (precision > 0) {
                    if (precision <= 4) {
                        type = ColumnType.SHORT;
                    } else if (precision <= 9) {
                        type = ColumnType.INTEGER;
                    } else if (precision <= 18) {
                        type = ColumnType.LONG;
                    }
                }
            } else if (scale <= 7) {
                type = ColumnType.FLOAT;
            } else if (scale <= 16) {
                type = ColumnType.DOUBLE;
            }
        }
        return type;
    }
}

