/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.time.LocalDate;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.DateAndTimePredicates;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.filtering.DateAndDateTimeFilterSpec;
import tech.tablesaw.filtering.predicates.IntBiPredicate;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface DateFilters
extends Column<LocalDate>,
DateAndDateTimeFilterSpec<Selection> {
    public DateColumn where(Selection var1);

    default public Selection eval(IntPredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntIterator iterator = this.intIterator();
        int idx = 0;
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (predicate.test(next)) {
                selection.add(idx);
            }
            ++idx;
        }
        return selection;
    }

    default public Selection eval(IntBiPredicate predicate, int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntIterator iterator = this.intIterator();
        int idx = 0;
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (predicate.test(next, value)) {
                selection.add(idx);
            }
            ++idx;
        }
        return selection;
    }

    default public Selection eval(IntBiPredicate predicate, DateColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.getIntInternal(idx), otherColumn.getIntInternal(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    public int getIntInternal(int var1);

    default public Selection eval(BiPredicate<LocalDate, LocalDate> predicate, LocalDate valueToCompare) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test((LocalDate)this.get(idx), valueToCompare)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(Predicate<LocalDate> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test((LocalDate)this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    @Override
    default public Selection isMonday() {
        return this.eval(PackedLocalDate::isMonday);
    }

    @Override
    default public Selection isTuesday() {
        return this.eval(PackedLocalDate::isTuesday);
    }

    @Override
    default public Selection isWednesday() {
        return this.eval(PackedLocalDate::isWednesday);
    }

    @Override
    default public Selection isThursday() {
        return this.eval(PackedLocalDate::isThursday);
    }

    @Override
    default public Selection isFriday() {
        return this.eval(PackedLocalDate::isFriday);
    }

    @Override
    default public Selection isSaturday() {
        return this.eval(PackedLocalDate::isSaturday);
    }

    @Override
    default public Selection isSunday() {
        return this.eval(PackedLocalDate::isSunday);
    }

    @Override
    default public Selection isInJanuary() {
        return this.eval(PackedLocalDate::isInJanuary);
    }

    @Override
    default public Selection isInFebruary() {
        return this.eval(PackedLocalDate::isInFebruary);
    }

    @Override
    default public Selection isInMarch() {
        return this.eval(PackedLocalDate::isInMarch);
    }

    @Override
    default public Selection isInApril() {
        return this.eval(PackedLocalDate::isInApril);
    }

    @Override
    default public Selection isInMay() {
        return this.eval(PackedLocalDate::isInMay);
    }

    @Override
    default public Selection isInJune() {
        return this.eval(PackedLocalDate::isInJune);
    }

    @Override
    default public Selection isInJuly() {
        return this.eval(PackedLocalDate::isInJuly);
    }

    @Override
    default public Selection isInAugust() {
        return this.eval(PackedLocalDate::isInAugust);
    }

    @Override
    default public Selection isInSeptember() {
        return this.eval(PackedLocalDate::isInSeptember);
    }

    @Override
    default public Selection isInOctober() {
        return this.eval(PackedLocalDate::isInOctober);
    }

    @Override
    default public Selection isInNovember() {
        return this.eval(PackedLocalDate::isInNovember);
    }

    @Override
    default public Selection isInDecember() {
        return this.eval(PackedLocalDate::isInDecember);
    }

    @Override
    default public Selection isFirstDayOfMonth() {
        return this.eval(PackedLocalDate::isFirstDayOfMonth);
    }

    @Override
    default public Selection isLastDayOfMonth() {
        return this.eval(PackedLocalDate::isLastDayOfMonth);
    }

    @Override
    default public Selection isInQ1() {
        return this.eval(PackedLocalDate::isInQ1);
    }

    @Override
    default public Selection isInQ2() {
        return this.eval(PackedLocalDate::isInQ2);
    }

    @Override
    default public Selection isInQ3() {
        return this.eval(PackedLocalDate::isInQ3);
    }

    @Override
    default public Selection isInQ4() {
        return this.eval(PackedLocalDate::isInQ4);
    }

    @Override
    default public Selection isInYear(int year) {
        return this.eval(PackedLocalDate::isInYear, year);
    }

    default public Selection isAfter(int value) {
        return this.eval(PackedLocalDate::isAfter, value);
    }

    @Override
    default public Selection isAfter(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.eval(PackedLocalDate::isAfter, packed);
    }

    default public Selection isBefore(int value) {
        return this.eval(PackedLocalDate::isBefore, value);
    }

    default public Selection isBetweenExcluding(int lowValue, int highValue) {
        return this.eval(PackedLocalDate::isAfter, lowValue).and(this.eval(PackedLocalDate::isBefore, highValue));
    }

    default public Selection isBetweenExcluding(LocalDate lowValue, LocalDate highValue) {
        return this.isBetweenExcluding(PackedLocalDate.pack(lowValue), PackedLocalDate.pack(highValue));
    }

    default public Selection isBetweenIncluding(LocalDate lowValue, LocalDate highValue) {
        return this.isBetweenIncluding(PackedLocalDate.pack(lowValue), PackedLocalDate.pack(highValue));
    }

    default public Selection isBetweenIncluding(int lowValue, int highValue) {
        return this.eval(PackedLocalDate::isOnOrAfter, lowValue).and(this.eval(PackedLocalDate::isOnOrBefore, highValue));
    }

    @Override
    default public Selection isBefore(LocalDate value) {
        return this.isBefore(PackedLocalDate.pack(value));
    }

    @Override
    default public Selection isOnOrBefore(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.eval(PackedLocalDate::isOnOrBefore, packed);
    }

    @Override
    default public Selection isOnOrAfter(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.eval(DateAndTimePredicates.isGreaterThanOrEqualTo, packed);
    }

    default public Selection isEqualTo(LocalDate value) {
        return this.eval(DateAndTimePredicates.isEqualTo, PackedLocalDate.pack(value));
    }

    default public Selection isEqualTo(int packedDate) {
        return this.eval(DateAndTimePredicates.isEqualTo, packedDate);
    }

    default public Selection isEqualTo(DateColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getIntInternal(i) != column.getIntInternal(i)) continue;
            results.add(i);
        }
        return results;
    }

    default public Selection isNotEqualTo(DateColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isEqualTo(column));
    }

    default public Selection isOnOrBefore(DateColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isAfter(column));
    }

    default public Selection isOnOrAfter(DateColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isBefore(column));
    }

    default public Selection isAfter(DateColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getIntInternal(i) <= column.getIntInternal(i)) continue;
            results.add(i);
        }
        return results;
    }

    default public Selection isBefore(DateColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getIntInternal(i) >= column.getIntInternal(i)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isMissing() {
        return this.eval(DateAndTimePredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(DateAndTimePredicates.isNotMissing);
    }

    public IntIterator intIterator();
}

