/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import com.google.common.collect.Lists;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.util.StringUtils;

public class IntParser
extends AbstractColumnParser<Integer> {
    private final boolean ignoreZeroDecimal;

    public IntParser(ColumnType columnType) {
        super(columnType);
        this.ignoreZeroDecimal = true;
    }

    public IntParser(IntColumnType columnType, ReadOptions readOptions) {
        super(columnType);
        if (readOptions.missingValueIndicator() != null) {
            this.missingValueStrings = Lists.newArrayList((Object[])new String[]{readOptions.missingValueIndicator()});
        }
        this.ignoreZeroDecimal = readOptions.ignoreZeroDecimal();
    }

    @Override
    public boolean canParse(String str) {
        if (this.isMissing(str)) {
            return true;
        }
        String s = str;
        try {
            if (this.ignoreZeroDecimal) {
                s = StringUtils.removeZeroDecimal(s);
            }
            Integer.parseInt(AbstractColumnParser.remove(s, ','));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Integer parse(String s) {
        return this.parseInt(s);
    }

    @Override
    public double parseDouble(String s) {
        return this.parseInt(s);
    }

    @Override
    public int parseInt(String str) {
        if (this.isMissing(str)) {
            return IntColumnType.missingValueIndicator();
        }
        String s = str;
        if (this.ignoreZeroDecimal) {
            s = StringUtils.removeZeroDecimal(s);
        }
        return Integer.parseInt(AbstractColumnParser.remove(s, ','));
    }
}

