/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import tech.tablesaw.aggregate.NumericAggregateFunction;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.sorting.Sort;
import tech.tablesaw.sorting.SortUtils;
import tech.tablesaw.sorting.comparators.IntComparatorChain;
import tech.tablesaw.table.Relation;

public class TableSlice
extends Relation {
    private final Table table;
    private String name;
    @Nullable
    private Selection selection;
    @Nullable
    private int[] sortOrder = null;

    public TableSlice(Table table, Selection rowSelection) {
        this.name = table.name();
        this.selection = rowSelection;
        this.table = table;
    }

    public TableSlice(Table table) {
        this.name = table.name();
        this.selection = null;
        this.table = table;
    }

    @Override
    public Column<?> column(int columnIndex) {
        Column<?> col = this.table.column(columnIndex);
        if (this.isSorted()) {
            return col.subset(this.sortOrder);
        }
        if (this.hasSelection()) {
            return col.where(this.selection);
        }
        return col;
    }

    @Override
    public Column<?> column(String columnName) {
        return this.column(this.table.columnIndex(columnName));
    }

    @Override
    public int columnCount() {
        return this.table.columnCount();
    }

    @Override
    public int rowCount() {
        if (this.hasSelection()) {
            return this.selection.size();
        }
        return this.table.rowCount();
    }

    @Override
    public List<Column<?>> columns() {
        ArrayList columns = new ArrayList();
        for (int i = 0; i < this.columnCount(); ++i) {
            columns.add(this.column(i));
        }
        return columns;
    }

    @Override
    public int columnIndex(Column<?> column) {
        return this.table.columnIndex(column);
    }

    @Override
    public Object get(int r, int c) {
        return this.table.get(this.mappedRowNumber(r), c);
    }

    @Override
    public String name() {
        return this.name;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public void clear() {
        this.sortOrder = null;
        this.selection = Selection.with(new int[0]);
    }

    public void removeSort() {
        this.sortOrder = null;
    }

    public void removeSelection() {
        this.selection = null;
    }

    @Override
    public List<String> columnNames() {
        return this.table.columnNames();
    }

    @Override
    public TableSlice addColumns(Column<?> ... column) {
        throw new UnsupportedOperationException("Class TableSlice does not support the addColumns operation");
    }

    @Override
    public TableSlice removeColumns(Column<?> ... columns) {
        throw new UnsupportedOperationException("Class TableSlice does not support the removeColumns operation");
    }

    @Override
    public Table first(int nRows) {
        PrimitiveIterator.OfInt it = this.sourceRowNumberIterator();
        Table copy = this.table.emptyCopy();
        for (int count = 0; it.hasNext() && count < nRows; ++count) {
            int row = it.nextInt();
            copy.addRow(this.table.row(row));
        }
        return copy;
    }

    @Override
    public TableSlice setName(String name) {
        this.name = name;
        return this;
    }

    public Table asTable() {
        Table table = Table.create(this.name());
        for (Column<?> column : this.columns()) {
            table.addColumns(new Column[]{column});
        }
        return table;
    }

    protected PrimitiveIterator.OfInt sourceRowNumberIterator() {
        if (this.isSorted()) {
            return Arrays.stream(this.sortOrder).iterator();
        }
        if (this.hasSelection()) {
            return this.selection.iterator();
        }
        return Selection.withRange(0, this.table.rowCount()).iterator();
    }

    public double reduce(String numberColumnName, NumericAggregateFunction function) {
        NumericColumn<?> column = this.table.numberColumn(numberColumnName);
        if (this.hasSelection()) {
            return (Double)function.summarize(column.where(this.selection));
        }
        return (Double)function.summarize(column);
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){
            private final Row row;
            {
                this.row = new Row(TableSlice.this);
            }

            @Override
            public Row next() {
                return this.row.next();
            }

            @Override
            public boolean hasNext() {
                return this.row.hasNext();
            }
        };
    }

    private boolean hasSelection() {
        return this.selection != null;
    }

    private boolean isSorted() {
        return this.sortOrder != null;
    }

    public int mappedRowNumber(int rowNumber) {
        if (this.isSorted()) {
            return this.sortOrder[rowNumber];
        }
        if (this.hasSelection()) {
            return this.selection.get(rowNumber);
        }
        return rowNumber;
    }

    public void sortOn(Sort key) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0);
        if (key.size() == 1) {
            IntComparator comparator = SortUtils.getComparator(this.table, key);
            this.sortOrder = this.sortOn(comparator);
        } else {
            IntComparatorChain chain = SortUtils.getChain(this.table, key);
            this.sortOrder = this.sortOn(chain);
        }
    }

    private int[] sortOn(IntComparator rowComparator) {
        int[] newRows = this.hasSelection() ? this.selection.toArray() : IntStream.range(0, this.table.rowCount()).toArray();
        IntArrays.parallelQuickSort((int[])newRows, (IntComparator)rowComparator);
        return newRows;
    }
}

