/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.analytic;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import tech.tablesaw.analytic.AggregateFunctions;
import tech.tablesaw.analytic.AnalyticQuery;
import tech.tablesaw.analytic.ArgumentList;
import tech.tablesaw.analytic.FunctionMetaData;
import tech.tablesaw.analytic.NumberingFunction;
import tech.tablesaw.analytic.NumberingFunctions;
import tech.tablesaw.analytic.WindowSlider;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.sorting.Sort;
import tech.tablesaw.sorting.SortUtils;
import tech.tablesaw.sorting.comparators.IntComparatorChain;
import tech.tablesaw.table.TableSlice;

final class AnalyticQueryEngine {
    private final AnalyticQuery query;
    private final Table destination;
    private final IntComparatorChain rowComparator;

    private AnalyticQueryEngine(AnalyticQuery query) {
        this.query = query;
        this.destination = Table.create("Analytic ~ " + query.getTable().name());
        Optional<Sort> sort = query.getSort();
        this.rowComparator = sort.isPresent() ? SortUtils.getChain(query.getTable(), sort.get()) : null;
    }

    public static AnalyticQueryEngine create(AnalyticQuery query) {
        return new AnalyticQueryEngine(query);
    }

    public Table execute() {
        this.addColumns();
        this.partition().forEach(this::processSlice);
        return this.destination;
    }

    private void processSlice(TableSlice slice) {
        this.orderBy(slice);
        this.processAggregateFunctions(slice);
        this.processNumberingFunctions(slice);
    }

    private void processAggregateFunctions(TableSlice slice) {
        for (String toColumn : this.query.getArgumentList().getAggregateFunctions().keySet()) {
            ArgumentList.FunctionCall<AggregateFunctions> functionCall = this.query.getArgumentList().getAggregateFunctions().get(toColumn);
            AggregateFunctions aggregateFunction = functionCall.getFunction();
            Column<?> sourceColumn = this.query.getTable().column(functionCall.getSourceColumnName());
            this.validateColumn(aggregateFunction, sourceColumn);
            Column<?> destinationColumn = this.destination.column(functionCall.getDestinationColumnName());
            new WindowSlider(this.query.getWindowFrame(), aggregateFunction, slice, sourceColumn, destinationColumn).execute();
        }
    }

    private void processNumberingFunctions(TableSlice slice) {
        for (String toColumn : this.query.getArgumentList().getNumberingFunctions().keySet()) {
            if (this.rowComparator == null) {
                throw new IllegalArgumentException("Cannot use Numbering Function without OrderBy");
            }
            ArgumentList.FunctionCall<NumberingFunctions> functionCall = this.query.getArgumentList().getNumberingFunctions().get(toColumn);
            NumberingFunctions numberingFunctions = functionCall.getFunction();
            NumberingFunction function = numberingFunctions.getImplementation();
            Column<?> destinationColumn = this.destination.column(functionCall.getDestinationColumnName());
            int prevRowNumber = -1;
            for (Row row : slice) {
                if (row.getRowNumber() == 0) {
                    function.addNextRow();
                } else if (this.rowComparator.compare(slice.mappedRowNumber(prevRowNumber), slice.mappedRowNumber(row.getRowNumber())) == 0) {
                    function.addEqualRow();
                } else {
                    function.addNextRow();
                }
                prevRowNumber = row.getRowNumber();
                destinationColumn.set(slice.mappedRowNumber(row.getRowNumber()), Integer.valueOf(function.getValue()));
            }
        }
    }

    private void validateColumn(FunctionMetaData function, Column<?> sourceColumn) {
        if (!function.isCompatibleColumn(sourceColumn.type())) {
            throw new IllegalArgumentException("Function: " + function.functionName() + " Is not compatible with column type: " + sourceColumn.type());
        }
    }

    private void addColumns() {
        this.destination.addColumns(this.query.getArgumentList().createEmptyDestinationColumns(this.query.getTable().rowCount()).toArray(new Column[0]));
    }

    private Iterable<TableSlice> partition() {
        if (this.query.getPartitionColumns().isEmpty()) {
            return ImmutableList.of((Object)new TableSlice(this.query.getTable()));
        }
        return this.query.getTable().splitOn(this.query.getPartitionColumns().toArray(new String[0]));
    }

    private void orderBy(TableSlice tableSlice) {
        this.query.getSort().ifPresent(tableSlice::sortOn);
    }
}

