/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.temporal;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.temporal.TemporalColumn;

public interface TemporalMapFunctions<T extends Temporal>
extends TemporalColumn<T> {
    public T min();

    @Override
    public TemporalColumn<T> emptyCopy();

    default public LongColumn differenceInMilliseconds(TemporalColumn<T> column2) {
        return this.difference(column2, ChronoUnit.MILLIS);
    }

    default public LongColumn differenceInSeconds(TemporalColumn<T> column2) {
        return this.difference(column2, ChronoUnit.SECONDS);
    }

    default public LongColumn differenceInMinutes(TemporalColumn<T> column2) {
        return this.difference(column2, ChronoUnit.MINUTES);
    }

    default public LongColumn differenceInHours(TemporalColumn<T> column2) {
        return this.difference(column2, ChronoUnit.HOURS);
    }

    default public LongColumn differenceInDays(TemporalColumn<T> column2) {
        return this.difference(column2, ChronoUnit.DAYS);
    }

    default public LongColumn differenceInYears(TemporalColumn<T> column2) {
        return this.difference(column2, ChronoUnit.YEARS);
    }

    default public LongColumn difference(TemporalColumn<T> column2, ChronoUnit unit) {
        LongColumn newColumn = LongColumn.create(this.name() + " - " + column2.name() + "[" + unit.name() + "]");
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r) || column2.isMissing(r)) {
                newColumn.appendMissing();
                continue;
            }
            long c1 = this.getLongInternal(r);
            long c2 = column2.getLongInternal(r);
            LocalDateTime value1 = PackedLocalDateTime.asLocalDateTime(c1);
            LocalDateTime value2 = PackedLocalDateTime.asLocalDateTime(c2);
            if (value1 != null && value2 != null) {
                newColumn.append(unit.between(value1, value2));
                continue;
            }
            newColumn.appendMissing();
        }
        return newColumn;
    }

    public Column<T> plus(long var1, ChronoUnit var3);

    default public Column<T> plusYears(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.YEARS);
    }

    default public Column<T> plusMonths(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.MONTHS);
    }

    default public Column<T> plusWeeks(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.WEEKS);
    }

    default public Column<T> plusDays(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.DAYS);
    }

    default public Column<T> plusHours(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.HOURS);
    }

    default public Column<T> plusMinutes(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.MINUTES);
    }

    default public Column<T> plusSeconds(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.SECONDS);
    }

    default public Column<T> plusMillis(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.MILLIS);
    }

    default public Column<T> plusMicros(long amountToAdd) {
        return this.plus(amountToAdd, ChronoUnit.MICROS);
    }

    default public BooleanColumn missingValues() {
        BooleanColumn newColumn = BooleanColumn.create(this.name() + " missing?");
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r)) {
                newColumn.append((byte)1);
                continue;
            }
            newColumn.append((byte)0);
        }
        return newColumn;
    }

    default public String temporalColumnName(Column<T> column1, long value, TemporalUnit unit) {
        return column1.name() + ": " + value + " " + unit.toString() + "(s)";
    }
}

