/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.booleans;

import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.Selection;

public interface BooleanMapUtils
extends Column<Boolean> {
    default public BooleanColumn and(BooleanColumn ... columns) {
        StringBuilder name = new StringBuilder(this.name()).append(" and: ");
        Selection selection = this.asSelection();
        for (BooleanColumn column : columns) {
            if (!column.name().equals(columns[0].name())) {
                name.append(", ");
            }
            name.append(column.name());
            selection.and(column.asSelection());
        }
        return BooleanColumn.create(name.toString(), selection, this.size());
    }

    default public BooleanColumn or(BooleanColumn ... columns) {
        StringBuilder name = new StringBuilder(this.name()).append(" or: ");
        Selection selection = this.asSelection();
        for (BooleanColumn column : columns) {
            if (!column.name().equals(columns[0].name())) {
                name.append(", ");
            }
            name.append(column.name());
            selection.or(column.asSelection());
        }
        return BooleanColumn.create(name.toString(), selection, this.size());
    }

    default public BooleanColumn andNot(BooleanColumn ... columns) {
        StringBuilder name = new StringBuilder(this.name()).append(" and not: ");
        Selection selection = this.asSelection();
        for (BooleanColumn column : columns) {
            if (!column.name().equals(columns[0].name())) {
                name.append(", ");
            }
            name.append(column.name());
            selection.andNot(column.asSelection());
        }
        return BooleanColumn.create(name.toString(), selection, this.size());
    }

    public Selection asSelection();
}

