/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.index.Index;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class StringIndex
implements Index {
    private final Map<String, IntArrayList> index;

    public StringIndex(StringColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        HashMap<String, IntArrayList> tempMap = new HashMap<String, IntArrayList>(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            String value = column.get(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.put(value, recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new HashMap<String, IntArrayList>(tempMap);
    }

    private static void addAllToSelection(IntArrayList tableKeys, Selection selection) {
        IntListIterator intListIterator = tableKeys.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            selection.add(i);
        }
    }

    public Selection get(String value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntArrayList list = this.index.get(value);
        if (list != null) {
            StringIndex.addAllToSelection(list, selection);
        }
        return selection;
    }
}

