/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.fixed;

import com.google.common.io.CharStreams;
import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.NormalizedString;
import com.univocity.parsers.fixed.FixedWidthFormat;
import com.univocity.parsers.fixed.FixedWidthParser;
import com.univocity.parsers.fixed.FixedWidthParserSettings;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.math3.util.Pair;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.FileReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.RuntimeIOException;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.fixed.FixedWidthReadOptions;

@Immutable
public class FixedWidthReader
extends FileReader
implements DataReader<FixedWidthReadOptions> {
    private static final FixedWidthReader INSTANCE = new FixedWidthReader();

    public static void register(ReaderRegistry registry) {
        registry.registerOptions(FixedWidthReadOptions.class, INSTANCE);
    }

    private Pair<Reader, ReadOptions.ColumnTypeReadOptions> getReaderAndColumnTypes(FixedWidthReadOptions options) {
        ReadOptions.ColumnTypeReadOptions columnTypeReadOptions = options.columnTypeReadOptions();
        byte[] bytesCache = null;
        boolean hasColumnNames = options.columnSpecs() != null && options.columnSpecs().getFieldNames() != null && options.columnSpecs().getFieldNames().length > 0;
        try {
            if (!(options.columnTypeReadOptions().hasColumnTypeForAllColumns() || options.columnTypeReadOptions().hasColumnTypeForAllColumnsIfHavingColumnNames() && hasColumnNames)) {
                Reader reader = options.source().createReader(bytesCache);
                if (options.source().file() == null) {
                    bytesCache = CharStreams.toString((Readable)reader).getBytes();
                    reader = options.source().createReader(bytesCache);
                }
                columnTypeReadOptions = ReadOptions.ColumnTypeReadOptions.of(this.detectColumnTypes(reader, options));
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        try {
            return Pair.create((Object)options.source().createReader(bytesCache), (Object)columnTypeReadOptions);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public Table read(FixedWidthReadOptions options) {
        return this.read(options, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table read(FixedWidthReadOptions options, boolean headerOnly) {
        Pair<Reader, ReadOptions.ColumnTypeReadOptions> pair = this.getReaderAndColumnTypes(options);
        Reader reader = (Reader)pair.getKey();
        ReadOptions.ColumnTypeReadOptions columnTypeReadOptions = (ReadOptions.ColumnTypeReadOptions)pair.getValue();
        FixedWidthParser parser = this.fixedWidthParser(options);
        try {
            Table table = this.parseRows(options, headerOnly, reader, columnTypeReadOptions, (AbstractParser<?>)parser);
            return table;
        }
        finally {
            if (options.source().reader() == null) {
                parser.stopParsing();
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }
    }

    public String printColumnTypes(FixedWidthReadOptions options) {
        Table structure = this.read(options, true).structure();
        return this.getTypeString(structure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnType[] detectColumnTypes(Reader reader, FixedWidthReadOptions options) {
        boolean header = options.header();
        int linesToSkip = header ? 1 : 0;
        FixedWidthParser parser = this.fixedWidthParser(options);
        try {
            String[] columnNames = Optional.ofNullable(options.columnSpecs()).flatMap(specs -> Optional.ofNullable(specs.getFieldNames())).map(fieldNames -> (String[])Arrays.stream(fieldNames).map(NormalizedString::toString).toArray(String[]::new)).orElse(null);
            ColumnType[] columnTypeArray = this.getColumnTypes(reader, options, linesToSkip, (AbstractParser<?>)parser, columnNames);
            return columnTypeArray;
        }
        finally {
            parser.stopParsing();
        }
    }

    private FixedWidthParser fixedWidthParser(FixedWidthReadOptions options) {
        FixedWidthParserSettings settings = new FixedWidthParserSettings();
        if (options.columnSpecs() != null) {
            settings = new FixedWidthParserSettings(options.columnSpecs());
        }
        settings.setFormat((Format)this.fixedWidthFormat(options));
        settings.setMaxCharsPerColumn(options.maxNumberOfColumns().intValue());
        if (options.skipTrailingCharsUntilNewline()) {
            settings.setSkipTrailingCharsUntilNewline(options.skipTrailingCharsUntilNewline());
        }
        if (options.maxNumberOfColumns() != null) {
            settings.setMaxColumns(options.maxNumberOfColumns().intValue());
        }
        if (options.recordEndsOnNewline()) {
            settings.setRecordEndsOnNewline(true);
        }
        return new FixedWidthParser(settings);
    }

    private FixedWidthFormat fixedWidthFormat(FixedWidthReadOptions options) {
        FixedWidthFormat format = new FixedWidthFormat();
        if (options.padding() != ' ') {
            format.setPadding(options.padding());
        }
        if (options.lookupWildcard() != '?') {
            format.setLookupWildcard(options.lookupWildcard());
        }
        if (options.lineEnding() != null) {
            format.setLineSeparator(options.lineEnding());
        }
        return format;
    }

    @Override
    public Table read(Source source) {
        return this.read(FixedWidthReadOptions.builder(source).build());
    }

    static {
        FixedWidthReader.register(Table.defaultReaderRegistry);
    }
}

