/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.TableSlice;

public class Row
implements Iterator<Row> {
    private final TableSlice tableSlice;
    private final String[] columnNames;
    private final ColumnMap<DateColumn> dateColumnMap = new ColumnMap();
    private final ColumnMap<DoubleColumn> doubleColumnMap = new ColumnMap(ColumnType.DOUBLE);
    private final ColumnMap<IntColumn> intColumnMap = new ColumnMap(ColumnType.INTEGER);
    private final ColumnMap<LongColumn> longColumnMap = new ColumnMap(ColumnType.LONG);
    private final ColumnMap<ShortColumn> shortColumnMap = new ColumnMap(ColumnType.SHORT);
    private final ColumnMap<FloatColumn> floatColumnMap = new ColumnMap(ColumnType.FLOAT);
    private final ColumnMap<Column<String>> stringColumnMap = new ColumnMap(ColumnType.STRING);
    private final ColumnMap<BooleanColumn> booleanColumnMap = new ColumnMap(ColumnType.BOOLEAN);
    private final ColumnMap<DateTimeColumn> dateTimeColumnMap = new ColumnMap(ColumnType.LOCAL_DATE_TIME);
    private final ColumnMap<InstantColumn> instantColumnMap = new ColumnMap(ColumnType.INSTANT);
    private final ColumnMap<TimeColumn> timeColumnMap = new ColumnMap(ColumnType.LOCAL_TIME);
    private final ColumnMap<Column<?>> columnMap = new ColumnMap();
    private final ColumnMap<NumericColumn<? extends Number>> numericColumnMap = new ColumnMap();
    private int rowNumber;

    public Row(Table table) {
        this(table, -1);
    }

    public Row(TableSlice tableSlice) {
        this(tableSlice, -1);
    }

    public Row(Table table, int rowNumber) {
        this(new TableSlice(table), rowNumber);
    }

    public Row(TableSlice tableSlice, int rowNumber) {
        this.tableSlice = tableSlice;
        this.columnNames = tableSlice.columnNames().toArray(new String[0]);
        this.rowNumber = rowNumber;
        for (Column<?> column : tableSlice.getTable().columns()) {
            if (column instanceof DoubleColumn) {
                this.doubleColumnMap.put(column.name(), (DoubleColumn)column);
                this.numericColumnMap.put(column.name(), (DoubleColumn)column);
            }
            if (column instanceof IntColumn) {
                this.intColumnMap.put(column.name(), (IntColumn)column);
                this.numericColumnMap.put(column.name(), (IntColumn)column);
            }
            if (column instanceof ShortColumn) {
                this.shortColumnMap.put(column.name(), (ShortColumn)column);
                this.numericColumnMap.put(column.name(), (ShortColumn)column);
            }
            if (column instanceof LongColumn) {
                this.longColumnMap.put(column.name(), (LongColumn)column);
                this.numericColumnMap.put(column.name(), (LongColumn)column);
            }
            if (column instanceof FloatColumn) {
                this.floatColumnMap.put(column.name(), (FloatColumn)column);
                this.numericColumnMap.put(column.name(), (FloatColumn)column);
            }
            if (column instanceof BooleanColumn) {
                this.booleanColumnMap.put(column.name(), (BooleanColumn)column);
            }
            if (column instanceof StringColumn) {
                this.stringColumnMap.put(column.name(), (StringColumn)column);
            }
            if (column instanceof DateColumn) {
                this.dateColumnMap.put(column.name(), (DateColumn)column);
            } else if (column instanceof DateTimeColumn) {
                this.dateTimeColumnMap.put(column.name(), (DateTimeColumn)column);
            } else if (column instanceof InstantColumn) {
                this.instantColumnMap.put(column.name(), (InstantColumn)column);
            } else if (column instanceof TimeColumn) {
                this.timeColumnMap.put(column.name(), (TimeColumn)column);
            }
            this.columnMap.put(column.name(), column);
        }
    }

    public ColumnType type(int columnIndex) {
        return this.tableSlice.column(columnIndex).type();
    }

    public void at(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int columnCount() {
        return this.tableSlice.columnCount();
    }

    public List<String> columnNames() {
        return this.tableSlice.columnNames();
    }

    public Boolean getBoolean(int columnIndex) {
        return this.getBoolean(this.columnNames[columnIndex]);
    }

    public byte getBooleanAsByte(int columnIndex) {
        return this.getBooleanAsByte(this.columnNames[columnIndex]);
    }

    public byte getBooleanAsByte(String columnName) {
        return this.booleanColumnMap.get(columnName).getByte(this.getIndex(this.rowNumber));
    }

    public Boolean getBoolean(String columnName) {
        return this.booleanColumnMap.get(columnName).get(this.getIndex(this.rowNumber));
    }

    public LocalDate getDate(String columnName) {
        return this.dateColumnMap.get(columnName).get(this.getIndex(this.rowNumber));
    }

    public LocalDate getDate(int columnIndex) {
        return this.dateColumnMap.get(this.columnNames[columnIndex]).get(this.getIndex(this.rowNumber));
    }

    public LocalDateTime getDateTime(int columnIndex) {
        return this.getDateTime(this.columnNames[columnIndex]);
    }

    public LocalDateTime getDateTime(String columnName) {
        return ((DateTimeColumn)this.columnMap.get(columnName)).get(this.getIndex(this.rowNumber));
    }

    public Instant getInstant(int columnIndex) {
        return this.getInstant(this.columnNames[columnIndex]);
    }

    public Instant getInstant(String columnName) {
        return ((InstantColumn)this.columnMap.get(columnName)).get(this.getIndex(this.rowNumber));
    }

    public double getDouble(int columnIndex) {
        return this.getDouble(this.columnNames[columnIndex]);
    }

    public double getDouble(String columnName) {
        return this.doubleColumnMap.get(columnName).getDouble(this.getIndex(this.rowNumber));
    }

    public float getFloat(int columnIndex) {
        return this.getFloat(this.columnNames[columnIndex]);
    }

    public float getFloat(String columnName) {
        return this.floatColumnMap.get(columnName).getFloat(this.getIndex(this.rowNumber));
    }

    public int getInt(int columnIndex) {
        return this.getInt(this.columnNames[columnIndex]);
    }

    public int getInt(String columnName) {
        return this.intColumnMap.get(columnName).getInt(this.getIndex(this.rowNumber));
    }

    public long getLong(int columnIndex) {
        return this.getLong(this.columnNames[columnIndex]);
    }

    public long getLong(String columnName) {
        return this.longColumnMap.get(columnName).getLong(this.getIndex(this.rowNumber));
    }

    public Object getObject(String columnName) {
        return this.columnMap.get(columnName).get(this.getIndex(this.rowNumber));
    }

    public Object getObject(int columnIndex) {
        return this.columnMap.get(this.columnNames[columnIndex]).get(this.getIndex(this.rowNumber));
    }

    public int getPackedDate(String columnName) {
        return this.dateColumnMap.get(columnName).getIntInternal(this.getIndex(this.rowNumber));
    }

    public int getPackedDate(int columnIndex) {
        return this.dateColumnMap.get(this.columnNames[columnIndex]).getIntInternal(this.getIndex(this.rowNumber));
    }

    public long getPackedInstant(int columnIndex) {
        return this.instantColumnMap.get(this.columnNames[columnIndex]).getLongInternal(this.getIndex(this.rowNumber));
    }

    public long getPackedInstant(String columnName) {
        return this.instantColumnMap.get(columnName).getLongInternal(this.getIndex(this.rowNumber));
    }

    public long getPackedDateTime(String columnName) {
        return this.dateTimeColumnMap.get(columnName).getLongInternal(this.getIndex(this.rowNumber));
    }

    public long getPackedDateTime(int columnIndex) {
        return this.dateTimeColumnMap.get(this.columnNames[columnIndex]).getLongInternal(this.getIndex(this.rowNumber));
    }

    public int getPackedTime(String columnName) {
        return this.timeColumnMap.get(columnName).getIntInternal(this.getIndex(this.rowNumber));
    }

    public int getPackedTime(int columnIndex) {
        return this.timeColumnMap.get(this.columnNames[columnIndex]).getIntInternal(this.getIndex(this.rowNumber));
    }

    public short getShort(int columnIndex) {
        return this.getShort(this.columnNames[columnIndex]);
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public String getString(int columnIndex) {
        return this.getString(this.columnNames[columnIndex]);
    }

    public short getShort(String columnName) {
        return this.shortColumnMap.get(columnName).getShort(this.getIndex(this.rowNumber));
    }

    public LocalTime getTime(String columnName) {
        return this.timeColumnMap.get(columnName).get(this.getIndex(this.rowNumber));
    }

    public LocalTime getTime(int columnIndex) {
        return this.timeColumnMap.get(this.columnNames[columnIndex]).get(this.getIndex(this.rowNumber));
    }

    public String getString(String columnName) {
        return this.stringColumnMap.get(columnName).get(this.getIndex(this.rowNumber));
    }

    public boolean isMissing(String columnName) {
        Column<?> x = this.columnMap.get(columnName);
        int i = this.getIndex(this.rowNumber);
        return x.isMissing(i);
    }

    @Override
    public boolean hasNext() {
        return this.rowNumber < this.tableSlice.rowCount() - 1;
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.rowNumber;
        return this;
    }

    public void setMissing(int columnIndex) {
        this.setMissing(this.columnNames[columnIndex]);
    }

    public void setMissing(String columnName) {
        this.columnMap.get(columnName).setMissing(this.getIndex(this.rowNumber));
    }

    public void setBoolean(int columnIndex, boolean value) {
        this.setBoolean(this.columnNames[columnIndex], value);
    }

    public void setBoolean(String columnName, boolean value) {
        this.booleanColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setDate(int columnIndex, LocalDate value) {
        this.setDate(this.columnNames[columnIndex], value);
    }

    public void setPackedDate(int columnIndex, int value) {
        this.setPackedDate(this.columnNames[columnIndex], value);
    }

    public void setDate(String columnName, LocalDate value) {
        this.dateColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setPackedDate(String columnName, int value) {
        this.dateColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setPackedTime(int columnIndex, int value) {
        this.setPackedTime(this.columnNames[columnIndex], value);
    }

    public void setPackedDateTime(int columnIndex, long value) {
        this.setPackedDateTime(this.columnNames[columnIndex], value);
    }

    public void setPackedInstant(int columnIndex, long value) {
        this.setPackedInstant(this.columnNames[columnIndex], value);
    }

    public void setPackedTime(String columnName, int value) {
        this.timeColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setPackedDateTime(String columnName, long value) {
        this.dateTimeColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setPackedInstant(String columnName, long value) {
        this.instantColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setBooleanAsByte(String columnName, byte value) {
        this.booleanColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setBooleanAsByte(int columnIndex, byte value) {
        this.setBooleanAsByte(this.columnNames[columnIndex], value);
    }

    public void setDateTime(int columnIndex, LocalDateTime value) {
        this.setDateTime(this.columnNames[columnIndex], value);
    }

    public void setDateTime(String columnName, LocalDateTime value) {
        this.dateTimeColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setInstant(int columnIndex, Instant value) {
        this.setInstant(this.columnNames[columnIndex], value);
    }

    public void setInstant(String columnName, Instant value) {
        this.instantColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setDouble(int columnIndex, double value) {
        this.setDouble(this.columnNames[columnIndex], value);
    }

    public void setDouble(String columnName, double value) {
        this.doubleColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setFloat(int columnIndex, float value) {
        this.setFloat(this.columnNames[columnIndex], value);
    }

    public void setFloat(String columnName, float value) {
        this.floatColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setInt(int columnIndex, int value) {
        this.setInt(this.columnNames[columnIndex], value);
    }

    public void setInt(String columnName, int value) {
        this.intColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setLong(int columnIndex, long value) {
        this.setLong(this.columnNames[columnIndex], value);
    }

    public void setLong(String columnName, long value) {
        this.longColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setShort(int columnIndex, short value) {
        this.setShort(this.columnNames[columnIndex], value);
    }

    public void setShort(String columnName, short value) {
        this.shortColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setString(int columnIndex, String value) {
        this.setString(this.columnNames[columnIndex], value);
    }

    public void setString(String columnName, String value) {
        this.stringColumnMap.get(columnName).set(this.getIndex(this.rowNumber), value);
    }

    public void setTime(int columnIndex, LocalTime value) {
        this.setTime(this.columnNames[columnIndex], value);
    }

    private int getIndex(int rowNumber) {
        return this.tableSlice.mappedRowNumber(rowNumber);
    }

    public int getBackingRowNumber() {
        return this.getIndex(this.getRowNumber());
    }

    public double getNumber(String columnName) {
        return this.numericColumnMap.get(columnName).getDouble(this.getIndex(this.rowNumber));
    }

    public ColumnType getColumnType(String columnName) {
        return this.columnMap.get(columnName).type();
    }

    public ColumnType getColumnType(int columnIndex) {
        return this.tableSlice.column(columnIndex).type();
    }

    public Column<?> column(int columnIndex) {
        return this.tableSlice.column(columnIndex);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        if (this.columnCount() != other.columnCount()) {
            return false;
        }
        for (int columnIndex = 0; columnIndex < this.columnCount(); ++columnIndex) {
            if (this.column(columnIndex).equals(this.getRowNumber(), other.getRowNumber())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int[] values = new int[this.columnCount()];
        for (int i = 0; i < this.columnCount(); ++i) {
            Column<?> column = this.tableSlice.column(i);
            values[i] = column.valueHash(this.rowNumber);
        }
        int result = 1;
        for (int hash : values) {
            result = 31 * result + hash;
        }
        return result;
    }

    public String toString() {
        Table t = this.tableSlice.getTable().emptyCopy();
        if (this.getRowNumber() == -1) {
            return "";
        }
        t.append(this);
        return t.print();
    }

    public void setTime(String columnName, LocalTime value) {
        this.timeColumnMap.get(columnName).set(this.rowNumber, value);
    }

    private class ColumnMap<T> {
        private final Map<String, T> columnMap = new HashMap<String, T>();
        private final ColumnType columnType;

        public ColumnMap(ColumnType columnType) {
            this.columnType = columnType;
        }

        ColumnMap() {
            this.columnType = null;
        }

        T get(String columnName) {
            T column = this.columnMap.get(columnName.toLowerCase());
            if (column == null) {
                this.throwWrongTypeError(columnName);
                this.throwColumnNotPresentError(columnName);
            }
            return column;
        }

        void put(String columnName, T column) {
            this.columnMap.put(columnName.toLowerCase(), column);
        }

        private void throwWrongTypeError(String columnName) {
            for (int i = 0; i < Row.this.columnNames.length; ++i) {
                if (!columnName.equals(Row.this.columnNames[i])) continue;
                String actualType = Row.this.tableSlice.getTable().columns().get(i).type().name();
                String proposedType = this.columnTypeName();
                throw new IllegalArgumentException(String.format("Column %s is of type %s and cannot be cast to %s. Use the method for %s.", columnName, actualType, proposedType, actualType));
            }
        }

        private void throwColumnNotPresentError(String columnName) {
            throw new IllegalStateException(String.format("Column %s is not present in table %s", columnName, Row.this.tableSlice.getTable().name()));
        }

        private String columnTypeName() {
            if (this.columnType != null) {
                return this.columnType.name();
            }
            return "Object";
        }
    }
}

