/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.booleans;

import tech.tablesaw.columns.ColumnFormatter;
import tech.tablesaw.columns.booleans.BooleanColumnType;

public class BooleanFormatter
extends ColumnFormatter {
    private String trueString = "true";
    private String falseString = "false";

    public BooleanFormatter(String trueString, String falseString, String missingString) {
        super(missingString);
        this.trueString = trueString;
        this.falseString = falseString;
    }

    public BooleanFormatter(String trueString, String falseString) {
        super("");
        this.trueString = trueString;
        this.falseString = falseString;
    }

    public BooleanFormatter(String missingString) {
        super(missingString);
    }

    public String format(Boolean value) {
        if (value == null) {
            return this.getMissingString();
        }
        if (value.booleanValue()) {
            return this.trueString;
        }
        return this.falseString;
    }

    public String format(byte value) {
        if (value == BooleanColumnType.MISSING_VALUE) {
            return this.getMissingString();
        }
        if (value == 1) {
            return this.trueString;
        }
        return this.falseString;
    }

    public String toString() {
        return "BooleanFormatter{trueString='" + this.trueString + "', falseString='" + this.falseString + "', missingString='" + this.getMissingString() + "'}";
    }
}

