/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.selection;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import java.util.Random;
import tech.tablesaw.selection.Selection;

public class BitSetBackedSelection
implements Selection {
    private static final Random random = new Random();
    private final BitSet bitmap;

    public BitSetBackedSelection(int size) {
        this.bitmap = new BitSet(size);
    }

    public BitSetBackedSelection(int[] arr) {
        this.bitmap = new BitSet(arr.length);
        this.add(arr);
    }

    public BitSetBackedSelection(BitSet bitmap) {
        this.bitmap = bitmap;
    }

    public BitSetBackedSelection() {
        this.bitmap = new BitSet();
    }

    @Override
    public BitSetBackedSelection removeRange(long start, long end) {
        this.bitmap.clear((int)start, (int)end);
        return this;
    }

    @Override
    public BitSetBackedSelection flip(int rangeStart, int rangeEnd) {
        this.bitmap.flip(rangeStart, rangeEnd);
        return this;
    }

    @Override
    public BitSetBackedSelection add(int ... ints) {
        for (int i : ints) {
            this.bitmap.set(i);
        }
        return this;
    }

    public String toString() {
        return "Selection of size: " + this.bitmap.cardinality();
    }

    @Override
    public int size() {
        return this.bitmap.cardinality();
    }

    @Override
    public int[] toArray() {
        return this.bitmap.stream().toArray();
    }

    private BitSet toBitmap(Selection otherSelection) {
        if (otherSelection instanceof BitSetBackedSelection) {
            return (BitSet)((BitSetBackedSelection)otherSelection).bitmap.clone();
        }
        BitSet bits = new BitSet();
        IntIterator intIterator = otherSelection.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            bits.set(i);
        }
        return bits;
    }

    @Override
    public Selection and(Selection otherSelection) {
        this.bitmap.and(this.toBitmap(otherSelection));
        return this;
    }

    @Override
    public Selection or(Selection otherSelection) {
        this.bitmap.or(this.toBitmap(otherSelection));
        return this;
    }

    @Override
    public Selection andNot(Selection otherSelection) {
        this.bitmap.andNot(this.toBitmap(otherSelection));
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Selection clear() {
        this.bitmap.clear();
        return this;
    }

    @Override
    public boolean contains(int i) {
        return this.bitmap.get(i);
    }

    @Override
    public Selection addRange(int start, int end) {
        this.bitmap.set(start, end);
        return this;
    }

    @Override
    public int get(int indexToFind) {
        if (indexToFind >= this.size()) {
            throw new IndexOutOfBoundsException("The requested index is larger than the selection");
        }
        int currentStep = 0;
        int currentIndex = 0;
        while (true) {
            int value = this.bitmap.nextSetBit(currentIndex);
            if (indexToFind == currentStep) {
                return value;
            }
            ++currentStep;
            currentIndex = value + 1;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitSetBackedSelection integers = (BitSetBackedSelection)o;
        return this.bitmap.equals(integers.bitmap);
    }

    public int hashCode() {
        return this.bitmap.hashCode();
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private final PrimitiveIterator.OfInt iterator;
            {
                this.iterator = BitSetBackedSelection.this.bitmap.stream().iterator();
            }

            public int nextInt() {
                return this.iterator.next();
            }

            public int skip(int k) {
                throw new UnsupportedOperationException("Views do not support skipping in the iterator");
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public static BitSetBackedSelection with(int ... rows) {
        BitSetBackedSelection selection = new BitSetBackedSelection();
        for (int i : rows) {
            selection.add(i);
        }
        return selection;
    }

    public static BitSetBackedSelection withRange(int start, int end) {
        BitSetBackedSelection selection = new BitSetBackedSelection();
        selection.addRange(start, end);
        return selection;
    }

    protected static Selection withoutRange(int totalRangeStart, int totalRangeEnd, int excludedRangeStart, int excludedRangeEnd) {
        Preconditions.checkArgument((excludedRangeStart >= totalRangeStart ? 1 : 0) != 0);
        Preconditions.checkArgument((excludedRangeEnd <= totalRangeEnd ? 1 : 0) != 0);
        Preconditions.checkArgument((totalRangeEnd >= totalRangeStart ? 1 : 0) != 0);
        Preconditions.checkArgument((excludedRangeEnd >= excludedRangeStart ? 1 : 0) != 0);
        BitSetBackedSelection selection = BitSetBackedSelection.withRange(totalRangeStart, totalRangeEnd);
        BitSetBackedSelection exclusion = BitSetBackedSelection.withRange(excludedRangeStart, excludedRangeEnd);
        selection.andNot(exclusion);
        return selection;
    }

    protected static BitSetBackedSelection selectNRowsAtRandom(int n, int max) {
        BitSetBackedSelection selection = new BitSetBackedSelection();
        if (n > max) {
            throw new IllegalArgumentException("Illegal arguments: N (" + n + ") greater than Max (" + max + ")");
        }
        int[] rows = new int[n];
        if (n == max) {
            int k = 0;
            while (k < n) {
                selection.add(k++);
            }
            return selection;
        }
        BitSet bs = new BitSet(max);
        int cardinality = 0;
        while (cardinality < n) {
            int v = random.nextInt(max);
            if (bs.get(v)) continue;
            bs.set(v);
            ++cardinality;
        }
        int pos = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            rows[pos++] = i;
            i = bs.nextSetBit(i + 1);
        }
        for (int row : rows) {
            selection.add(row);
        }
        return selection;
    }

    @VisibleForTesting
    BitSet bitSet() {
        return this.bitmap;
    }
}

