/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import java.io.PrintStream;

public class AddCellToColumnException
extends RuntimeException {
    private final int columnIndex;
    private final long rowNumber;
    private final String[] columnNames;
    private final String[] line;

    public AddCellToColumnException(Exception e, int columnIndex, long rowNumber, String[] columnNames, String[] line) {
        super("Error while addding cell from row " + rowNumber + " and column " + columnNames[columnIndex] + "(position:" + columnIndex + "): " + e.getMessage(), e);
        this.columnIndex = columnIndex;
        this.rowNumber = rowNumber;
        this.columnNames = columnNames;
        this.line = line;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public long getRowNumber() {
        return this.rowNumber;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnName() {
        return this.columnNames[this.columnIndex];
    }

    public void dumpRow(PrintStream out) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            out.print("Column ");
            out.print(i);
            out.print(" ");
            out.print(this.columnNames[i]);
            out.print(" : ");
            try {
                out.println(this.line[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                out.println("Unable to get cell " + i + " of this line");
            }
        }
    }
}

