/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public final class HtmlTableWriter {
    private HtmlTableWriter() {
    }

    public static String write(Table table, String missing) {
        StringBuilder builder = new StringBuilder();
        builder.append(HtmlTableWriter.header(table.columnNames()));
        builder.append("<tbody>").append('\n');
        for (int row : table.rows()) {
            builder.append(HtmlTableWriter.row(row, table, missing));
        }
        builder.append("</tbody>");
        return builder.toString();
    }

    @VisibleForTesting
    static String row(int row, Table table, String missing) {
        StringBuilder builder = new StringBuilder().append("<tr>");
        for (Column col : table.columns()) {
            builder.append("<td>").append(String.valueOf(col.getString(row))).append("</td>");
        }
        builder.append("</tr>").append('\n');
        return builder.toString();
    }

    @VisibleForTesting
    static String header(List<String> columnNames) {
        StringBuilder builder = new StringBuilder().append("<thead>").append('\n').append("<tr>");
        for (String name : columnNames) {
            builder.append("<th>").append(HtmlTableWriter.splitCamelCase(HtmlTableWriter.splitOnUnderscore(name))).append("</th>");
        }
        builder.append("</tr>").append('\n').append("</thead>").append('\n');
        return builder.toString();
    }

    private static String splitCamelCase(String s) {
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)s), (char)' ');
    }

    static String splitOnUnderscore(String s) {
        return StringUtils.join((Object[])StringUtils.split((String)s, (char)'_'), (char)' ');
    }
}

