/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.reducing;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import org.apache.commons.math3.util.FastMath;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.reducing.NumericReduceFunction;

public class NumericReduceUtils {
    public static NumericReduceFunction count = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Count";
        }

        @Override
        public double reduce(double[] data) {
            return data.length;
        }
    };
    public static NumericReduceFunction mean = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Mean";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.mean((double[])data);
        }
    };
    public static NumericReduceFunction sum = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Sum";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.sum((double[])data);
        }

        @Override
        public double reduce(FloatColumn floatColumn) {
            float sum = 0.0f;
            FloatIterator floatIterator = floatColumn.iterator();
            while (floatIterator.hasNext()) {
                float value = ((Float)floatIterator.next()).floatValue();
                if (value == Float.NaN) continue;
                sum += value;
            }
            return sum;
        }

        @Override
        public double reduce(DoubleColumn floatColumn) {
            float sum = 0.0f;
            DoubleIterator doubleIterator = floatColumn.iterator();
            while (doubleIterator.hasNext()) {
                double value = (Double)doubleIterator.next();
                if (value == Double.NaN) continue;
                sum = (float)((double)sum + value);
            }
            return sum;
        }
    };
    public static NumericReduceFunction median = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Median";
        }

        @Override
        public double reduce(double[] data) {
            return NumericReduceUtils.percentile(data, 50.0);
        }
    };
    public static NumericReduceFunction n = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "N";
        }

        @Override
        public double reduce(double[] data) {
            return data.length;
        }
    };
    public static NumericReduceFunction quartile1 = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "First Quartile";
        }

        @Override
        public double reduce(double[] data) {
            return NumericReduceUtils.percentile(data, 25.0);
        }
    };
    public static NumericReduceFunction quartile3 = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Third Quartile";
        }

        @Override
        public double reduce(double[] data) {
            return NumericReduceUtils.percentile(data, 75.0);
        }
    };
    public static NumericReduceFunction percentile90 = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "90th Percentile";
        }

        @Override
        public double reduce(double[] data) {
            return NumericReduceUtils.percentile(data, 90.0);
        }
    };
    public static NumericReduceFunction percentile95 = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "95th Percentile";
        }

        @Override
        public double reduce(double[] data) {
            return NumericReduceUtils.percentile(data, 95.0);
        }
    };
    public static NumericReduceFunction percentile99 = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "99th Percentile";
        }

        @Override
        public double reduce(double[] data) {
            return NumericReduceUtils.percentile(data, 99.0);
        }
    };
    public static NumericReduceFunction range = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Range";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.max((double[])data) - StatUtils.min((double[])data);
        }
    };
    public static NumericReduceFunction min = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Min";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.min((double[])data);
        }

        @Override
        public double reduce(FloatColumn data) {
            if (data.size() == 0) {
                return Double.NaN;
            }
            float min = data.firstElement();
            FloatIterator floatIterator = data.iterator();
            while (floatIterator.hasNext()) {
                float value = ((Float)floatIterator.next()).floatValue();
                if (Float.isNaN(value)) continue;
                min = min < value ? min : value;
            }
            return min;
        }
    };
    public static NumericReduceFunction max = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Max";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.max((double[])data);
        }
    };
    public static NumericReduceFunction product = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Product";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.product((double[])data);
        }

        @Override
        public double reduce(FloatColumn data) {
            float product = 1.0f;
            boolean empty = true;
            FloatIterator floatIterator = data.iterator();
            while (floatIterator.hasNext()) {
                float value = ((Float)floatIterator.next()).floatValue();
                if (value == Float.NaN) continue;
                empty = false;
                product *= value;
            }
            if (empty) {
                return Double.NaN;
            }
            return product;
        }
    };
    public static NumericReduceFunction geometricMean = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Geometric Mean";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.geometricMean((double[])data);
        }
    };
    public static NumericReduceFunction populationVariance = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Population Variance";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.populationVariance((double[])data);
        }
    };
    public static NumericReduceFunction quadraticMean = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Quadratic Mean";
        }

        @Override
        public double reduce(double[] data) {
            return new DescriptiveStatistics(data).getQuadraticMean();
        }
    };
    public static NumericReduceFunction kurtosis = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Kurtosis";
        }

        @Override
        public double reduce(double[] data) {
            return new Kurtosis().evaluate(data, 0, data.length);
        }
    };
    public static NumericReduceFunction skewness = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Skewness";
        }

        @Override
        public double reduce(double[] data) {
            return new Skewness().evaluate(data, 0, data.length);
        }
    };
    public static NumericReduceFunction sumOfSquares = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Sum of Squares";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.sumSq((double[])data);
        }
    };
    public static NumericReduceFunction sumOfLogs = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Sum of Logs";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.sumLog((double[])data);
        }
    };
    public static NumericReduceFunction variance = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Variance";
        }

        @Override
        public double reduce(double[] data) {
            return StatUtils.variance((double[])data);
        }

        @Override
        public double reduce(FloatColumn column) {
            double avg = mean.reduce(column);
            double sumSquaredDiffs = 0.0;
            FloatIterator floatIterator = column.iterator();
            while (floatIterator.hasNext()) {
                float value = ((Float)floatIterator.next()).floatValue();
                double diff = (double)value - avg;
                double sqrdDiff = diff * diff;
                sumSquaredDiffs += sqrdDiff;
            }
            return sumSquaredDiffs / (double)(column.size() - 1);
        }
    };
    public static NumericReduceFunction stdDev = new NumericReduceFunction(){

        @Override
        public String functionName() {
            return "Std. Deviation";
        }

        @Override
        public double reduce(double[] data) {
            return Math.sqrt(StatUtils.variance((double[])data));
        }

        public double stdDev(FloatColumn values) {
            float stdDev = Float.NaN;
            int N = values.size();
            if (N > 0) {
                stdDev = N > 1 ? (float)FastMath.sqrt((double)variance.reduce(values)) : 0.0f;
            }
            return stdDev;
        }
    };

    public static double percentile(double[] data, double percentile) {
        return StatUtils.percentile((double[])data, (double)percentile);
    }

    public static double meanDifference(FloatColumn column1, FloatColumn column2) {
        return StatUtils.meanDifference((double[])column1.toDoubleArray(), (double[])column2.toDoubleArray());
    }

    public static double sumDifference(FloatColumn column1, FloatColumn column2) {
        return StatUtils.sumDifference((double[])column1.toDoubleArray(), (double[])column2.toDoubleArray());
    }
}

