/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.util.collections;

import com.google.common.collect.BoundType;
import com.google.common.primitives.Booleans;
import java.util.NoSuchElementException;
import tech.tablesaw.util.collections.IntegerDomain;

abstract class IntCut
implements Comparable<IntCut> {
    protected final int endpoint;

    IntCut(int endpoint) {
        this.endpoint = endpoint;
    }

    static IntCut belowAll() {
        return BelowAll.INSTANCE;
    }

    static IntCut aboveAll() {
        return AboveAll.INSTANCE;
    }

    static IntCut belowValue(int endpoint) {
        return new BelowValue(endpoint);
    }

    static IntCut aboveValue(int endpoint) {
        return new AboveValue(endpoint);
    }

    abstract boolean isLessThan(int var1);

    abstract BoundType typeAsLowerBound();

    abstract BoundType typeAsUpperBound();

    abstract IntCut withLowerBoundType(BoundType var1, IntegerDomain var2);

    abstract IntCut withUpperBoundType(BoundType var1, IntegerDomain var2);

    abstract void describeAsLowerBound(StringBuilder var1);

    abstract void describeAsUpperBound(StringBuilder var1);

    abstract int leastValueAbove(IntegerDomain var1);

    abstract int greatestValueBelow(IntegerDomain var1);

    IntCut canonical(IntegerDomain domain) {
        return this;
    }

    @Override
    public int compareTo(IntCut that) {
        if (that == IntCut.belowAll()) {
            return 1;
        }
        if (that == IntCut.aboveAll()) {
            return -1;
        }
        int result = Integer.compare(this.endpoint, that.endpoint);
        if (result != 0) {
            return result;
        }
        return Booleans.compare((boolean)(this instanceof AboveValue), (boolean)(that instanceof AboveValue));
    }

    int endpoint() {
        return this.endpoint;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntCut) {
            IntCut that = (IntCut)obj;
            int compareResult = this.compareTo(that);
            return compareResult == 0;
        }
        return false;
    }

    private static final class BelowAll
    extends IntCut {
        private static final BelowAll INSTANCE = new BelowAll();

        private BelowAll() {
            super(Integer.MIN_VALUE);
        }

        @Override
        int endpoint() {
            throw new IllegalStateException("range unbounded on this side");
        }

        @Override
        boolean isLessThan(int value) {
            return true;
        }

        @Override
        BoundType typeAsLowerBound() {
            throw new IllegalStateException();
        }

        @Override
        BoundType typeAsUpperBound() {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        IntCut withLowerBoundType(BoundType boundType, IntegerDomain domain) {
            throw new IllegalStateException();
        }

        @Override
        IntCut withUpperBoundType(BoundType boundType, IntegerDomain domain) {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append("(-\u221e");
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        int leastValueAbove(IntegerDomain domain) {
            return domain.minValue();
        }

        @Override
        int greatestValueBelow(IntegerDomain domain) {
            throw new AssertionError();
        }

        @Override
        IntCut canonical(IntegerDomain domain) {
            try {
                return IntCut.belowValue(domain.minValue());
            }
            catch (NoSuchElementException var3) {
                return this;
            }
        }

        @Override
        public int compareTo(IntCut o) {
            return o == this ? 0 : -1;
        }

        public String toString() {
            return "-\u221e";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class AboveAll
    extends IntCut {
        private static final AboveAll INSTANCE = new AboveAll();

        private AboveAll() {
            super(Integer.MAX_VALUE);
        }

        static IntCut belowValue(int endpoint) {
            return new BelowValue(endpoint);
        }

        @Override
        int endpoint() {
            throw new IllegalStateException("range unbounded on this side");
        }

        @Override
        boolean isLessThan(int value) {
            return false;
        }

        @Override
        BoundType typeAsLowerBound() {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        BoundType typeAsUpperBound() {
            throw new IllegalStateException();
        }

        @Override
        IntCut withLowerBoundType(BoundType boundType, IntegerDomain domain) {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        IntCut withUpperBoundType(BoundType boundType, IntegerDomain domain) {
            throw new IllegalStateException();
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append("+\u221e)");
        }

        @Override
        int leastValueAbove(IntegerDomain domain) {
            throw new AssertionError();
        }

        @Override
        int greatestValueBelow(IntegerDomain domain) {
            return domain.maxValue();
        }

        @Override
        public int compareTo(IntCut o) {
            return o == this ? 0 : 1;
        }

        public String toString() {
            return "+\u221e";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class BelowValue
    extends IntCut {
        BelowValue(int endpoint) {
            super(endpoint);
        }

        static IntCut aboveValue(int endpoint) {
            return new AboveValue(endpoint);
        }

        @Override
        boolean isLessThan(int value) {
            return Integer.compare(this.endpoint, value) <= 0;
        }

        @Override
        BoundType typeAsLowerBound() {
            return BoundType.CLOSED;
        }

        @Override
        BoundType typeAsUpperBound() {
            return BoundType.OPEN;
        }

        @Override
        IntCut withLowerBoundType(BoundType boundType, IntegerDomain domain) {
            switch (boundType) {
                case CLOSED: {
                    return this;
                }
                case OPEN: {
                    Integer previous = domain.previous(this.endpoint);
                    return previous == null ? IntCut.belowAll() : new AboveValue(previous);
                }
            }
            throw new AssertionError();
        }

        @Override
        IntCut withUpperBoundType(BoundType boundType, IntegerDomain domain) {
            switch (boundType) {
                case CLOSED: {
                    Integer previous = domain.previous(this.endpoint);
                    return previous == null ? IntCut.aboveAll() : new AboveValue(previous);
                }
                case OPEN: {
                    return this;
                }
            }
            throw new AssertionError();
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append('[').append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(')');
        }

        @Override
        int leastValueAbove(IntegerDomain domain) {
            return this.endpoint;
        }

        @Override
        int greatestValueBelow(IntegerDomain domain) {
            return domain.previous(this.endpoint);
        }

        public int hashCode() {
            return this.endpoint;
        }

        public String toString() {
            return "\\" + this.endpoint + "/";
        }
    }

    private static final class AboveValue
    extends IntCut {
        AboveValue(int endpoint) {
            super(endpoint);
        }

        @Override
        boolean isLessThan(int value) {
            return Integer.compare(this.endpoint, value) < 0;
        }

        @Override
        BoundType typeAsLowerBound() {
            return BoundType.OPEN;
        }

        @Override
        BoundType typeAsUpperBound() {
            return BoundType.CLOSED;
        }

        @Override
        IntCut withLowerBoundType(BoundType boundType, IntegerDomain domain) {
            switch (boundType) {
                case OPEN: {
                    return this;
                }
                case CLOSED: {
                    Integer next = domain.next(this.endpoint);
                    return next == null ? IntCut.belowAll() : AboveValue.belowValue(next);
                }
            }
            throw new AssertionError();
        }

        @Override
        IntCut withUpperBoundType(BoundType boundType, IntegerDomain domain) {
            switch (boundType) {
                case OPEN: {
                    Integer next = domain.next(this.endpoint);
                    return next == null ? IntCut.aboveAll() : AboveValue.belowValue(next);
                }
                case CLOSED: {
                    return this;
                }
            }
            throw new AssertionError();
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append('(').append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(']');
        }

        @Override
        int leastValueAbove(IntegerDomain domain) {
            return domain.next(this.endpoint);
        }

        @Override
        int greatestValueBelow(IntegerDomain domain) {
            return this.endpoint;
        }

        @Override
        IntCut canonical(IntegerDomain domain) {
            Integer next = this.leastValueAbove(domain);
            return next != null ? AboveValue.belowValue(next) : IntCut.aboveAll();
        }

        public int hashCode() {
            return this.endpoint;
        }

        public String toString() {
            return "/" + this.endpoint + "\\";
        }
    }
}

