/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.util.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.SortedSet;
import javax.annotation.Nullable;
import tech.tablesaw.util.collections.IntCut;
import tech.tablesaw.util.collections.IntegerDomain;

public final class IntRange {
    private static final IntRange ALL = new IntRange(IntCut.belowAll(), IntCut.aboveAll());
    final IntCut lowerBound;
    final IntCut upperBound;

    private IntRange(IntCut lowerBound, IntCut upperBound) {
        this.lowerBound = (IntCut)Preconditions.checkNotNull((Object)lowerBound);
        this.upperBound = (IntCut)Preconditions.checkNotNull((Object)upperBound);
        if (lowerBound.compareTo(upperBound) > 0 || lowerBound == IntCut.aboveAll() || upperBound == IntCut.belowAll()) {
            throw new IllegalArgumentException("Invalid range: " + IntRange.toString(lowerBound, upperBound));
        }
    }

    static IntRange create(IntCut lowerBound, IntCut upperBound) {
        return new IntRange(lowerBound, upperBound);
    }

    public static IntRange open(int lower, int upper) {
        return IntRange.create(IntCut.aboveValue(lower), IntCut.belowValue(upper));
    }

    public static IntRange closed(int lower, int upper) {
        return IntRange.create(IntCut.belowValue(lower), IntCut.aboveValue(upper));
    }

    public static IntRange closedOpen(int lower, int upper) {
        return IntRange.create(IntCut.belowValue(lower), IntCut.belowValue(upper));
    }

    public static IntRange openClosed(int lower, int upper) {
        return IntRange.create(IntCut.aboveValue(lower), IntCut.aboveValue(upper));
    }

    public static IntRange range(int lower, BoundType lowerType, int upper, BoundType upperType) {
        Preconditions.checkNotNull((Object)lowerType);
        Preconditions.checkNotNull((Object)upperType);
        IntCut lowerBound = lowerType == BoundType.OPEN ? IntCut.aboveValue(lower) : IntCut.belowValue(lower);
        IntCut upperBound = upperType == BoundType.OPEN ? IntCut.belowValue(upper) : IntCut.aboveValue(upper);
        return IntRange.create(lowerBound, upperBound);
    }

    public static IntRange lessThan(int endpoint) {
        return IntRange.create(IntCut.belowAll(), IntCut.belowValue(endpoint));
    }

    public static IntRange atMost(int endpoint) {
        return IntRange.create(IntCut.belowAll(), IntCut.aboveValue(endpoint));
    }

    public static IntRange upTo(int endpoint, BoundType boundType) {
        switch (boundType) {
            case OPEN: {
                return IntRange.lessThan(endpoint);
            }
            case CLOSED: {
                return IntRange.atMost(endpoint);
            }
        }
        throw new AssertionError();
    }

    public static IntRange greaterThan(int endpoint) {
        return IntRange.create(IntCut.aboveValue(endpoint), IntCut.aboveAll());
    }

    public static IntRange atLeast(int endpoint) {
        return IntRange.create(IntCut.belowValue(endpoint), IntCut.aboveAll());
    }

    public static IntRange downTo(int endpoint, BoundType boundType) {
        switch (boundType) {
            case OPEN: {
                return IntRange.greaterThan(endpoint);
            }
            case CLOSED: {
                return IntRange.atLeast(endpoint);
            }
        }
        throw new AssertionError();
    }

    public static IntRange all() {
        return ALL;
    }

    public static IntRange singleton(int value) {
        return IntRange.closed(value, value);
    }

    public static IntRange encloseAll(IntCollection values) {
        int min;
        Preconditions.checkNotNull((Object)values);
        if (values instanceof IntSortedSet) {
            IntSortedSet setValues = (IntSortedSet)values;
            return IntRange.closed(setValues.firstInt(), setValues.lastInt());
        }
        IntIterator valueIterator = values.iterator();
        int max = min = ((Integer)Preconditions.checkNotNull((Object)valueIterator.next())).intValue();
        while (valueIterator.hasNext()) {
            int value = (Integer)Preconditions.checkNotNull((Object)valueIterator.next());
            min = Integer.min(min, value);
            max = Integer.max(max, value);
        }
        return IntRange.closed(min, max);
    }

    private static String toString(IntCut lowerBound, IntCut upperBound) {
        StringBuilder sb = new StringBuilder(16);
        lowerBound.describeAsLowerBound(sb);
        sb.append("..");
        upperBound.describeAsUpperBound(sb);
        return sb.toString();
    }

    private static <T> SortedSet<T> cast(Iterable<T> iterable) {
        return (SortedSet)iterable;
    }

    public IntCut upperBound() {
        return this.upperBound;
    }

    public IntCut lowerBound() {
        return this.lowerBound;
    }

    public boolean hasLowerBound() {
        return this.lowerBound != IntCut.belowAll();
    }

    public int lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public boolean hasUpperBound() {
        return this.upperBound != IntCut.aboveAll();
    }

    public int upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    public boolean contains(int value) {
        return this.lowerBound.isLessThan(value) && !this.upperBound.isLessThan(value);
    }

    public boolean containsAll(IntCollection values) {
        if (values.isEmpty()) {
            return true;
        }
        if (values instanceof IntSortedSet) {
            IntSortedSet set = (IntSortedSet)values;
            return this.contains(set.first()) && this.contains(set.last());
        }
        IntIterator intIterator = values.iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean encloses(IntRange other) {
        return this.lowerBound.compareTo(other.lowerBound) <= 0 && this.upperBound.compareTo(other.upperBound) >= 0;
    }

    public boolean isConnected(IntRange other) {
        return this.lowerBound.compareTo(other.upperBound) <= 0 && other.lowerBound.compareTo(this.upperBound) <= 0;
    }

    public IntRange intersection(IntRange connectedRange) {
        int lowerCmp = this.lowerBound.compareTo(connectedRange.lowerBound);
        int upperCmp = this.upperBound.compareTo(connectedRange.upperBound);
        if (lowerCmp >= 0 && upperCmp <= 0) {
            return this;
        }
        if (lowerCmp <= 0 && upperCmp >= 0) {
            return connectedRange;
        }
        IntCut newLower = lowerCmp >= 0 ? this.lowerBound : connectedRange.lowerBound;
        IntCut newUpper = upperCmp <= 0 ? this.upperBound : connectedRange.upperBound;
        return IntRange.create(newLower, newUpper);
    }

    public IntRange span(IntRange other) {
        int lowerCmp = this.lowerBound.compareTo(other.lowerBound);
        int upperCmp = this.upperBound.compareTo(other.upperBound);
        if (lowerCmp <= 0 && upperCmp >= 0) {
            return this;
        }
        if (lowerCmp >= 0 && upperCmp <= 0) {
            return other;
        }
        IntCut newLower = lowerCmp <= 0 ? this.lowerBound : other.lowerBound;
        IntCut newUpper = upperCmp >= 0 ? this.upperBound : other.upperBound;
        return IntRange.create(newLower, newUpper);
    }

    public IntRange canonical(IntegerDomain domain) {
        Preconditions.checkNotNull((Object)domain);
        IntCut lower = this.lowerBound.canonical(domain);
        IntCut upper = this.upperBound.canonical(domain);
        return lower == this.lowerBound && upper == this.upperBound ? this : IntRange.create(lower, upper);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof IntRange) {
            IntRange other = (IntRange)object;
            return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        return IntRange.toString(this.lowerBound, this.upperBound);
    }

    Object readResolve() {
        if (this.equals(ALL)) {
            return IntRange.all();
        }
        return this;
    }
}

