/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.saw;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.ByteDictionaryMap;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.IntDictionaryMap;
import tech.tablesaw.columns.strings.ShortDictionaryMap;
import tech.tablesaw.io.saw.SawUtils;

@Beta
public class ColumnMetadata {
    private String id;
    private String name;
    private String type;
    private int cardinality;
    private String stringColumnKeySize;
    private int nextStringKey;

    ColumnMetadata(Column<?> column) {
        this.id = SawUtils.makeName(column.name());
        this.name = column.name();
        this.type = column.type().name();
        if (column instanceof StringColumn) {
            StringColumn stringColumn = (StringColumn)column;
            this.cardinality = stringColumn.countUnique();
            DictionaryMap lookupTable = stringColumn.getDictionary();
            this.nextStringKey = lookupTable.nextKeyWithoutIncrementing();
            this.stringColumnKeySize = lookupTable.getClass().equals(IntDictionaryMap.class) ? Integer.class.getSimpleName() : (lookupTable.getClass().equals(ByteDictionaryMap.class) ? Byte.class.getSimpleName() : (lookupTable.getClass().equals(ShortDictionaryMap.class) ? Short.class.getSimpleName() : ""));
        } else {
            this.stringColumnKeySize = "";
        }
    }

    protected ColumnMetadata() {
    }

    public String toString() {
        return "ColumnMetadata{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + this.type + '}';
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getStringColumnKeySize() {
        return this.stringColumnKeySize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadata that = (ColumnMetadata)o;
        return Objects.equal((Object)this.getId(), (Object)that.getId()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getType(), (Object)that.getType()) && Objects.equal((Object)this.getStringColumnKeySize(), (Object)that.getStringColumnKeySize());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getName(), this.getType(), this.getStringColumnKeySize()});
    }

    public int getNextStringKey() {
        return this.nextStringKey;
    }

    public int getCardinality() {
        return this.cardinality;
    }
}

