/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.saw;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ReadOptions {
    private static final int READER_POOL_SIZE = 8;
    private List<String> selectedColumns = new ArrayList<String>();
    private int threadPoolSize = 8;

    public static ReadOptions defaultOptions() {
        return new ReadOptions();
    }

    public ReadOptions threadPoolSize(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        this.threadPoolSize = size;
        return this;
    }

    public ReadOptions selectedColumns(String ... columnNames) {
        this.selectedColumns = Lists.newArrayList((Object[])columnNames);
        return this;
    }

    public ReadOptions selectedColumns(List<String> columnNames) {
        this.selectedColumns = columnNames;
        return this;
    }

    public List<String> getSelectedColumns() {
        return this.selectedColumns;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }
}

