/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.saw;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.saw.ColumnMetadata;
import tech.tablesaw.io.saw.CompressionType;
import tech.tablesaw.io.saw.EncryptionType;
import tech.tablesaw.io.saw.TableMetadata;
import tech.tablesaw.io.saw.WriteOptions;
import tech.tablesaw.table.Relation;

public class SawMetadata {
    static final String METADATA_FILE_NAME = "Metadata.json";
    private static final int SAW_VERSION = 2;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private TableMetadata tableMetadata;
    private int version;
    private CompressionType compressionType;
    private EncryptionType encryptionType;

    static SawMetadata readMetadata(Path sawPath) {
        byte[] encoded;
        Path resolvePath = sawPath.resolve(METADATA_FILE_NAME);
        try {
            encoded = Files.readAllBytes(resolvePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read Saw Metadata file at " + resolvePath.toString(), e);
        }
        return SawMetadata.fromJson(new String(encoded, StandardCharsets.UTF_8));
    }

    public SawMetadata(Table table, WriteOptions options) {
        this.tableMetadata = new TableMetadata((Relation)table);
        this.version = 2;
        this.compressionType = options.getCompressionType();
        this.encryptionType = options.getEncryptionType();
    }

    protected SawMetadata() {
    }

    static SawMetadata fromJson(String jsonString) {
        try {
            return (SawMetadata)objectMapper.readValue(jsonString, SawMetadata.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    String toJson() {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public int getVersion() {
        return this.version;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    @JsonIgnore
    public List<ColumnMetadata> getColumnMetadataList() {
        return this.tableMetadata.getColumnMetadataList();
    }

    @JsonIgnore
    public Table structure() {
        return this.tableMetadata.structure();
    }

    @JsonIgnore
    public String getTableName() {
        return this.tableMetadata.getName();
    }

    @JsonIgnore
    public List<String> columnNames() {
        return this.tableMetadata.columnNames();
    }

    @JsonIgnore
    public int getRowCount() {
        return this.tableMetadata.getRowCount();
    }

    public int columnCount() {
        return this.tableMetadata.columnCount();
    }

    public String shape() {
        return this.tableMetadata.shape();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SawMetadata that = (SawMetadata)o;
        return this.getVersion() == that.getVersion() && Objects.equal((Object)this.getTableMetadata(), (Object)that.getTableMetadata()) && this.getCompressionType() == that.getCompressionType();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTableMetadata(), this.getVersion(), this.getCompressionType()});
    }
}

