/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.saw;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.bytes.Byte2IntOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2IntOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.iq80.snappy.SnappyFramedInputStream;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.ByteDictionaryMap;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.IntDictionaryMap;
import tech.tablesaw.columns.strings.ShortDictionaryMap;
import tech.tablesaw.io.saw.ColumnMetadata;
import tech.tablesaw.io.saw.CompressionType;
import tech.tablesaw.io.saw.ReadOptions;
import tech.tablesaw.io.saw.SawMetadata;

@Beta
public class SawReader {
    private final Path sawPath;
    private final SawMetadata sawMetadata;
    private ReadOptions readOptions = ReadOptions.defaultOptions();

    public SawReader(Path sawPath) {
        this.sawPath = sawPath;
        this.sawMetadata = SawMetadata.readMetadata(sawPath);
    }

    public SawReader(Path sawPath, ReadOptions options) {
        this.sawPath = sawPath;
        this.readOptions = options;
        this.sawMetadata = SawMetadata.readMetadata(sawPath);
    }

    public SawReader(File sawPathFile) {
        this.sawPath = sawPathFile.toPath();
        this.sawMetadata = SawMetadata.readMetadata(this.sawPath);
    }

    public SawReader(File sawPathFile, ReadOptions options) {
        this.sawPath = sawPathFile.toPath();
        this.readOptions = options;
        this.sawMetadata = SawMetadata.readMetadata(this.sawPath);
    }

    public SawReader(String sawPathName) {
        this.sawPath = this.setPath(sawPathName);
        this.sawMetadata = SawMetadata.readMetadata(this.sawPath);
    }

    public SawReader(String sawPathName, ReadOptions options) {
        this.sawPath = this.setPath(sawPathName);
        this.readOptions = options;
        this.sawMetadata = SawMetadata.readMetadata(this.sawPath);
    }

    private Path setPath(String parentFolderName) {
        Preconditions.checkArgument((parentFolderName != null ? 1 : 0) != 0, (Object)"The folder name for the saw output cannot be null");
        Preconditions.checkArgument((!parentFolderName.isEmpty() ? 1 : 0) != 0, (Object)"The folder name for the saw output cannot be empty");
        return Paths.get(parentFolderName, new String[0]);
    }

    public String shape() {
        return this.sawMetadata.shape();
    }

    public int columnCount() {
        return this.sawMetadata.columnCount();
    }

    public int rowCount() {
        return this.sawMetadata.getRowCount();
    }

    public List<String> columnNames() {
        return this.sawMetadata.columnNames();
    }

    public Table structure() {
        return this.sawMetadata.structure();
    }

    public Table read() {
        ExecutorService executor = Executors.newFixedThreadPool(this.readOptions.getThreadPoolSize());
        HashSet<String> selectedColumns = new HashSet<String>(this.readOptions.getSelectedColumns());
        List<ColumnMetadata> columnMetadata = this.getMetadata(selectedColumns);
        Table table = Table.create((String)this.sawMetadata.getTableName());
        ArrayList<Callable<Column>> callables = new ArrayList<Callable<Column>>();
        ConcurrentHashMap<String, Column> columns = new ConcurrentHashMap<String, Column>();
        try {
            for (ColumnMetadata column : columnMetadata) {
                callables.add(() -> {
                    Path columnPath = this.sawPath.resolve(column.getId());
                    return this.readColumn(columnPath.toString(), this.sawMetadata, column);
                });
            }
            List futures = executor.invokeAll(callables);
            for (Future future : futures) {
                Column column = (Column)future.get();
                columns.put(column.name(), column);
            }
            for (ColumnMetadata metadata : columnMetadata) {
                table.internalAddWithoutValidation((Column)columns.get(metadata.getName()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        finally {
            executor.shutdown();
        }
        return table;
    }

    private List<ColumnMetadata> getMetadata(Set<String> selectedColumns) {
        if (selectedColumns.isEmpty()) {
            return ImmutableList.copyOf(this.sawMetadata.getColumnMetadataList());
        }
        return ImmutableList.copyOf((Collection)this.sawMetadata.getColumnMetadataList().stream().filter(x -> selectedColumns.contains(x.getName())).collect(Collectors.toList()));
    }

    private Column<?> readColumn(String fileName, SawMetadata sawMetadata, ColumnMetadata columnMetadata) throws IOException {
        String typeString = columnMetadata.getType();
        int rowcount = sawMetadata.getRowCount();
        switch (typeString) {
            case "FLOAT": {
                return this.readFloatColumn(fileName, columnMetadata, rowcount);
            }
            case "DOUBLE": {
                return this.readDoubleColumn(fileName, columnMetadata, rowcount);
            }
            case "INTEGER": {
                return this.readIntColumn(fileName, columnMetadata, rowcount);
            }
            case "BOOLEAN": {
                return this.readBooleanColumn(fileName, columnMetadata, rowcount);
            }
            case "LOCAL_DATE": {
                return this.readLocalDateColumn(fileName, columnMetadata, rowcount);
            }
            case "LOCAL_TIME": {
                return this.readLocalTimeColumn(fileName, columnMetadata, rowcount);
            }
            case "LOCAL_DATE_TIME": {
                return this.readLocalDateTimeColumn(fileName, columnMetadata, rowcount);
            }
            case "INSTANT": {
                return this.readInstantColumn(fileName, columnMetadata, rowcount);
            }
            case "STRING": {
                return this.readStringColumn(fileName, columnMetadata, rowcount);
            }
            case "TEXT": {
                return this.readTextColumn(fileName, columnMetadata, rowcount);
            }
            case "SHORT": {
                return this.readShortColumn(fileName, columnMetadata, rowcount);
            }
            case "LONG": {
                return this.readLongColumn(fileName, columnMetadata, rowcount);
            }
        }
        throw new IllegalStateException("Unhandled column type writing columns: " + typeString);
    }

    private DataInputStream inputStream(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        if (this.sawMetadata.getCompressionType().equals((Object)CompressionType.NONE)) {
            return new DataInputStream(fis);
        }
        SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
        return new DataInputStream((InputStream)sis);
    }

    private FloatColumn readFloatColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        float[] data = new float[rowcount];
        try (DataInputStream dis = this.inputStream(fileName);){
            for (int i = 0; i < rowcount; ++i) {
                data[i] = dis.readFloat();
            }
        }
        return FloatColumn.create((String)metadata.getName(), (float[])data);
    }

    private DoubleColumn readDoubleColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        double[] data = new double[rowcount];
        try (DataInputStream dis = this.inputStream(fileName);){
            for (int i = 0; i < rowcount; ++i) {
                data[i] = dis.readDouble();
            }
        }
        return DoubleColumn.create((String)metadata.getName(), (double[])data);
    }

    private IntColumn readIntColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        return IntColumn.create((String)metadata.getName(), (int[])this.readIntValues(fileName, rowcount));
    }

    private ShortColumn readShortColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        short[] data = new short[rowcount];
        try (DataInputStream dis = this.inputStream(fileName);){
            for (int i = 0; i < rowcount; ++i) {
                data[i] = dis.readShort();
            }
        }
        return ShortColumn.create((String)metadata.getName(), (short[])data);
    }

    private LongColumn readLongColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        return LongColumn.create((String)metadata.getName(), (long[])this.readLongValues(fileName, rowcount));
    }

    private DateColumn readLocalDateColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        return DateColumn.createInternal((String)metadata.getName(), (int[])this.readIntValues(fileName, rowcount));
    }

    private int[] readIntValues(String fileName, int rowcount) throws IOException {
        int[] data = new int[rowcount];
        try (DataInputStream dis = this.inputStream(fileName);){
            for (int i = 0; i < rowcount; ++i) {
                data[i] = dis.readInt();
            }
        }
        return data;
    }

    private DateTimeColumn readLocalDateTimeColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        long[] data = this.readLongValues(fileName, rowcount);
        return DateTimeColumn.createInternal((String)metadata.getName(), (long[])data);
    }

    private long[] readLongValues(String fileName, int rowcount) throws IOException {
        long[] data = new long[rowcount];
        try (DataInputStream dis = this.inputStream(fileName);){
            for (int i = 0; i < rowcount; ++i) {
                data[i] = dis.readLong();
            }
        }
        return data;
    }

    private InstantColumn readInstantColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        return InstantColumn.createInternal((String)metadata.getName(), (long[])this.readLongValues(fileName, rowcount));
    }

    private TimeColumn readLocalTimeColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        return TimeColumn.createInternal((String)metadata.getName(), (int[])this.readIntValues(fileName, rowcount));
    }

    private StringColumn readStringColumn(String fileName, ColumnMetadata columnMetadata, int rowcount) throws IOException {
        try (DataInputStream dis = this.inputStream(fileName);){
            if (columnMetadata.getStringColumnKeySize().equals(Byte.class.getSimpleName())) {
                StringColumn stringColumn = StringColumn.createInternal((String)columnMetadata.getName(), (DictionaryMap)this.getByteMap(dis, columnMetadata, rowcount));
                return stringColumn;
            }
            if (columnMetadata.getStringColumnKeySize().equals(Integer.class.getSimpleName())) {
                StringColumn stringColumn = StringColumn.createInternal((String)columnMetadata.getName(), (DictionaryMap)this.getIntMap(dis, columnMetadata, rowcount));
                return stringColumn;
            }
            StringColumn stringColumn = StringColumn.createInternal((String)columnMetadata.getName(), (DictionaryMap)this.getShortMap(dis, columnMetadata, rowcount));
            return stringColumn;
        }
    }

    private ByteDictionaryMap getByteMap(DataInputStream dis, ColumnMetadata metaData, int rowcount) throws IOException {
        int k;
        int cardinality = metaData.getCardinality();
        byte[] data = new byte[rowcount];
        byte[] keys = new byte[cardinality];
        byte[] countKeys = new byte[cardinality];
        Object[] values = new String[cardinality];
        int[] counts = new int[cardinality];
        for (k = 0; k < cardinality; ++k) {
            keys[k] = dis.readByte();
        }
        for (k = 0; k < cardinality; ++k) {
            values[k] = dis.readUTF();
        }
        for (k = 0; k < cardinality; ++k) {
            countKeys[k] = dis.readByte();
        }
        for (k = 0; k < cardinality; ++k) {
            counts[k] = dis.readInt();
        }
        for (int i = 0; i < rowcount; ++i) {
            data[i] = dis.readByte();
        }
        Object2ByteOpenHashMap valueToKey = new Object2ByteOpenHashMap(values, keys);
        Byte2ObjectOpenHashMap keyToValue = new Byte2ObjectOpenHashMap(keys, values);
        Byte2IntOpenHashMap keyToCount = new Byte2IntOpenHashMap(countKeys, counts);
        return new ByteDictionaryMap.ByteDictionaryBuilder().setValues(data).setValueToKey(valueToKey).setKeyToValue((Byte2ObjectMap)keyToValue).setKeyToCount(keyToCount).setNextIndex(metaData.getNextStringKey()).build();
    }

    private ShortDictionaryMap getShortMap(DataInputStream dis, ColumnMetadata metaData, int rowcount) throws IOException {
        int k;
        int cardinality = metaData.getCardinality();
        short[] data = new short[rowcount];
        short[] keys = new short[cardinality];
        short[] countKeys = new short[cardinality];
        Object[] values = new String[cardinality];
        int[] counts = new int[cardinality];
        for (k = 0; k < cardinality; ++k) {
            keys[k] = dis.readShort();
        }
        for (k = 0; k < cardinality; ++k) {
            values[k] = dis.readUTF();
        }
        for (k = 0; k < cardinality; ++k) {
            countKeys[k] = dis.readShort();
        }
        for (k = 0; k < cardinality; ++k) {
            counts[k] = dis.readInt();
        }
        for (int i = 0; i < rowcount; ++i) {
            data[i] = dis.readShort();
        }
        Object2ShortOpenHashMap valueToKey = new Object2ShortOpenHashMap(values, keys);
        Short2ObjectOpenHashMap keyToValue = new Short2ObjectOpenHashMap(keys, values);
        Short2IntOpenHashMap keyToCount = new Short2IntOpenHashMap(countKeys, counts);
        return new ShortDictionaryMap.ShortDictionaryBuilder().setValues(data).setValueToKey(valueToKey).setKeyToValue((Short2ObjectMap)keyToValue).setKeyToCount(keyToCount).setNextIndex(metaData.getNextStringKey()).build();
    }

    private IntDictionaryMap getIntMap(DataInputStream dis, ColumnMetadata metaData, int rowcount) throws IOException {
        int k;
        int cardinality = metaData.getCardinality();
        int[] data = new int[rowcount];
        int[] keys = new int[cardinality];
        int[] countKeys = new int[cardinality];
        Object[] values = new String[cardinality];
        int[] counts = new int[cardinality];
        for (k = 0; k < cardinality; ++k) {
            keys[k] = dis.readInt();
        }
        for (k = 0; k < cardinality; ++k) {
            values[k] = dis.readUTF();
        }
        for (k = 0; k < cardinality; ++k) {
            countKeys[k] = dis.readInt();
        }
        for (k = 0; k < cardinality; ++k) {
            counts[k] = dis.readInt();
        }
        for (int i = 0; i < rowcount; ++i) {
            data[i] = dis.readInt();
        }
        Object2IntOpenHashMap valueToKey = new Object2IntOpenHashMap(values, keys);
        Int2ObjectOpenHashMap keyToValue = new Int2ObjectOpenHashMap(keys, values);
        Int2IntOpenHashMap keyToCount = new Int2IntOpenHashMap(countKeys, counts);
        return new IntDictionaryMap.IntDictionaryBuilder().setValues(data).setValueToKey(valueToKey).setKeyToValue((Int2ObjectMap)keyToValue).setKeyToCount(keyToCount).setNextIndex(metaData.getNextStringKey()).build();
    }

    private TextColumn readTextColumn(String fileName, ColumnMetadata columnMetadata, int rowcount) throws IOException {
        TextColumn textColumn = TextColumn.create((String)columnMetadata.getName(), (int)rowcount);
        try (DataInputStream dis = this.inputStream(fileName);){
            for (int j = 0; j < rowcount; ++j) {
                textColumn.set(j, dis.readUTF());
            }
        }
        return textColumn;
    }

    private BooleanColumn readBooleanColumn(String fileName, ColumnMetadata metadata, int rowcount) throws IOException {
        BooleanColumn column = BooleanColumn.create((String)metadata.getName());
        try (DataInputStream dis = this.inputStream(fileName);){
            for (int i = 0; i < rowcount; ++i) {
                column.append(dis.readByte());
            }
        }
        return column;
    }
}

