/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.saw;

import com.google.common.annotations.Beta;
import java.nio.file.FileSystems;
import java.util.regex.Pattern;

@Beta
class SawUtils {
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    private static final String FILE_EXTENSION = "saw";
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(FileSystems.getDefault().getSeparator()));
    static final String FLOAT = "FLOAT";
    static final String DOUBLE = "DOUBLE";
    static final String INTEGER = "INTEGER";
    static final String LONG = "LONG";
    static final String SHORT = "SHORT";
    static final String STRING = "STRING";
    static final String TEXT = "TEXT";
    static final String INSTANT = "INSTANT";
    static final String LOCAL_DATE = "LOCAL_DATE";
    static final String LOCAL_TIME = "LOCAL_TIME";
    static final String LOCAL_DATE_TIME = "LOCAL_DATE_TIME";
    static final String BOOLEAN = "BOOLEAN";

    private SawUtils() {
    }

    static String makeName(String name) {
        String nm = WHITE_SPACE_PATTERN.matcher(name).replaceAll("");
        nm = SEPARATOR_PATTERN.matcher(nm).replaceAll("_");
        return nm + '.' + FILE_EXTENSION;
    }
}

