/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.saw;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.bytes.Byte2IntMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.Short2IntMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.iq80.snappy.SnappyFramedOutputStream;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.ByteDictionaryMap;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.IntDictionaryMap;
import tech.tablesaw.columns.strings.ShortDictionaryMap;
import tech.tablesaw.io.saw.CompressionType;
import tech.tablesaw.io.saw.SawMetadata;
import tech.tablesaw.io.saw.SawUtils;
import tech.tablesaw.io.saw.WriteOptions;

@Beta
public class SawWriter {
    private static final int FLUSH_AFTER_ITERATIONS = 20000;
    private final SawMetadata sawMetadata;
    private final Table table;
    private final WriteOptions writeOptions;
    private final Path path;

    public SawWriter(Path path, Table table, WriteOptions options) {
        this.path = path;
        this.sawMetadata = new SawMetadata(table, options);
        this.table = table;
        this.writeOptions = options;
    }

    public SawWriter(String path, Table table, WriteOptions options) {
        this.path = this.setPath(path);
        this.sawMetadata = new SawMetadata(table, options);
        this.table = table;
        this.writeOptions = options;
    }

    public SawWriter(File file, Table table, WriteOptions options) {
        this.path = file.toPath();
        this.sawMetadata = new SawMetadata(table, options);
        this.table = table;
        this.writeOptions = options;
    }

    public SawWriter(Path path, Table table) {
        this.path = path;
        this.table = table;
        this.writeOptions = WriteOptions.defaultOptions();
        this.sawMetadata = new SawMetadata(table, this.writeOptions);
    }

    public SawWriter(File file, Table table) {
        this.path = file.toPath();
        this.table = table;
        this.writeOptions = WriteOptions.defaultOptions();
        this.sawMetadata = new SawMetadata(table, this.writeOptions);
    }

    public SawWriter(String path, Table table) {
        this.path = this.setPath(path);
        this.table = table;
        this.writeOptions = WriteOptions.defaultOptions();
        this.sawMetadata = new SawMetadata(table, this.writeOptions);
    }

    private Path setPath(String parentFolderName) {
        Preconditions.checkArgument((parentFolderName != null ? 1 : 0) != 0, (Object)"The folder name for the saw output cannot be null");
        Preconditions.checkArgument((!parentFolderName.isEmpty() ? 1 : 0) != 0, (Object)"The folder name for the saw output cannot be empty");
        return Paths.get(parentFolderName, new String[0]);
    }

    public String write() {
        try {
            return this.saveTable();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String saveTable() throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.writeOptions.getThreadPoolSize());
        ExecutorCompletionService<Void> writerCompletionService = new ExecutorCompletionService<Void>(executorService);
        this.createFolder(this.path);
        String sawFolderName = SawUtils.makeName(this.table.name());
        Path filePath = this.path.resolve(sawFolderName);
        if (Files.exists(filePath, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(filePath, new FileVisitOption[0]);){
                stream.map(Path::toFile).sorted((o1, o2) -> Comparator.reverseOrder().compare((File)o1, (File)o2)).forEach(File::delete);
            }
        }
        Files.createDirectories(filePath, new FileAttribute[0]);
        this.writeTableMetadata(filePath, this.sawMetadata);
        try {
            int i;
            List columns = this.table.columns();
            for (i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                String pathString = this.sawMetadata.getColumnMetadataList().get(i).getId();
                writerCompletionService.submit(() -> {
                    Path columnPath = filePath.resolve(pathString);
                    this.writeColumn(columnPath.toString(), column);
                    return null;
                });
            }
            for (i = 0; i < this.table.columnCount(); ++i) {
                Future future = writerCompletionService.take();
                future.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        finally {
            executorService.shutdown();
        }
        return filePath.toAbsolutePath().toString();
    }

    private void createFolder(Path folderPath) {
        if (!Files.exists(folderPath, new LinkOption[0])) {
            try {
                Files.createDirectories(folderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void writeColumn(String fileName, Column<?> column) {
        try {
            String typeName;
            switch (typeName = column.type().name()) {
                case "FLOAT": {
                    this.writeColumn(fileName, (FloatColumn)column);
                    break;
                }
                case "DOUBLE": {
                    this.writeColumn(fileName, (DoubleColumn)column);
                    break;
                }
                case "INTEGER": {
                    this.writeColumn(fileName, (IntColumn)column);
                    break;
                }
                case "BOOLEAN": {
                    this.writeColumn(fileName, (BooleanColumn)column);
                    break;
                }
                case "LOCAL_DATE": {
                    this.writeColumn(fileName, (DateColumn)column);
                    break;
                }
                case "LOCAL_TIME": {
                    this.writeColumn(fileName, (TimeColumn)column);
                    break;
                }
                case "LOCAL_DATE_TIME": {
                    this.writeColumn(fileName, (DateTimeColumn)column);
                    break;
                }
                case "STRING": {
                    this.writeColumn(fileName, (StringColumn)column);
                    break;
                }
                case "TEXT": {
                    this.writeColumn(fileName, (TextColumn)column);
                    break;
                }
                case "INSTANT": {
                    this.writeColumn(fileName, (InstantColumn)column);
                    break;
                }
                case "SHORT": {
                    this.writeColumn(fileName, (ShortColumn)column);
                    break;
                }
                case "LONG": {
                    this.writeColumn(fileName, (LongColumn)column);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled column type writing columns");
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("IOException writing to file", e);
        }
    }

    private void writeColumn(String fileName, FloatColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            int i = 0;
            FloatIterator iterator = (FloatIterator)column.iterator();
            while (iterator.hasNext()) {
                dos.writeFloat(iterator.nextFloat());
                if (++i != 20000) continue;
                dos.flush();
                i = 0;
            }
            dos.flush();
        }
    }

    private void writeColumn(String fileName, DoubleColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            int i = 0;
            Iterator iterator = column.iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                dos.writeDouble(d);
                if (++i != 20000) continue;
                dos.flush();
                i = 0;
            }
            dos.flush();
        }
    }

    private void writeColumn(String fileName, StringColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            DictionaryMap lookupTable = column.getDictionary();
            if (lookupTable.getClass().equals(ByteDictionaryMap.class)) {
                this.writeToStream((ByteDictionaryMap)lookupTable, dos);
            } else if (lookupTable.getClass().equals(ShortDictionaryMap.class)) {
                this.writeToStream((ShortDictionaryMap)lookupTable, dos);
            } else {
                this.writeToStream((IntDictionaryMap)lookupTable, dos);
            }
        }
    }

    private void writeToStream(ByteDictionaryMap dictionary, DataOutputStream dos) {
        try {
            ObjectSet entries = dictionary.getKeyValueEntries();
            for (Byte2ObjectMap.Entry entry : entries) {
                dos.writeByte(entry.getByteKey());
            }
            for (Byte2ObjectMap.Entry entry : entries) {
                dos.writeUTF((String)entry.getValue());
            }
            Byte2IntMap.FastEntrySet counts = dictionary.getKeyCountEntries();
            for (Byte2IntMap.Entry count : counts) {
                dos.writeByte(count.getByteKey());
            }
            for (Byte2IntMap.Entry count : counts) {
                dos.writeInt(count.getIntValue());
            }
            ObjectIterator objectIterator = dictionary.values().iterator();
            while (objectIterator.hasNext()) {
                byte d = (Byte)objectIterator.next();
                dos.writeByte(d);
            }
            dos.flush();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private void writeToStream(ShortDictionaryMap dictionary, DataOutputStream dos) {
        try {
            ObjectSet entries = dictionary.getKeyValueEntries();
            for (Short2ObjectMap.Entry entry : entries) {
                dos.writeShort(entry.getShortKey());
            }
            for (Short2ObjectMap.Entry entry : entries) {
                dos.writeUTF((String)entry.getValue());
            }
            Short2IntMap.FastEntrySet counts = dictionary.getKeyCountEntries();
            for (Short2IntMap.Entry count : counts) {
                dos.writeShort(count.getShortKey());
            }
            for (Short2IntMap.Entry count : counts) {
                dos.writeInt(count.getIntValue());
            }
            ObjectIterator objectIterator = dictionary.values().iterator();
            while (objectIterator.hasNext()) {
                short d = (Short)objectIterator.next();
                dos.writeShort(d);
            }
            dos.flush();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private void writeToStream(IntDictionaryMap dictionary, DataOutputStream dos) {
        try {
            ObjectSet entries = dictionary.getKeyValueEntries();
            for (Int2ObjectMap.Entry entry : entries) {
                dos.writeInt(entry.getIntKey());
            }
            for (Int2ObjectMap.Entry entry : entries) {
                dos.writeUTF((String)entry.getValue());
            }
            Int2IntMap.FastEntrySet counts = dictionary.getKeyCountEntries();
            for (Int2IntMap.Entry count : counts) {
                dos.writeInt(count.getIntKey());
            }
            for (Int2IntMap.Entry count : counts) {
                dos.writeInt(count.getIntValue());
            }
            ObjectIterator objectIterator = dictionary.values().iterator();
            while (objectIterator.hasNext()) {
                int d = (Integer)objectIterator.next();
                dos.writeInt(d);
            }
            dos.flush();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    DataOutputStream columnOutputStream(String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        if (this.sawMetadata.getCompressionType().equals((Object)CompressionType.NONE)) {
            return new DataOutputStream(fos);
        }
        SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
        return new DataOutputStream((OutputStream)sos);
    }

    private void writeColumn(String fileName, TextColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            int i = 0;
            for (String s : column) {
                dos.writeUTF(s);
                if (++i != 20000) continue;
                dos.flush();
                i = 0;
            }
            dos.flush();
        }
    }

    private void writeColumn(String fileName, IntColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            this.writeIntStream(dos, column.intIterator());
            dos.flush();
        }
    }

    private void writeIntStream(DataOutputStream dos, IntIterator iterator) throws IOException {
        int i = 0;
        while (iterator.hasNext()) {
            dos.writeInt(iterator.nextInt());
            if (++i != 20000) continue;
            dos.flush();
            i = 0;
        }
    }

    private void writeLongStream(DataOutputStream dos, LongIterator iterator) throws IOException {
        int i = 0;
        while (iterator.hasNext()) {
            dos.writeLong(iterator.nextLong());
            if (++i != 20000) continue;
            dos.flush();
            i = 0;
        }
    }

    private void writeColumn(String fileName, ShortColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            int i = 0;
            ShortIterator iterator = (ShortIterator)column.iterator();
            while (iterator.hasNext()) {
                dos.writeShort(iterator.nextShort());
                if (++i != 20000) continue;
                dos.flush();
                i = 0;
            }
            dos.flush();
        }
    }

    private void writeColumn(String fileName, LongColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            this.writeLongStream(dos, column.longIterator());
            dos.flush();
        }
    }

    private void writeColumn(String fileName, DateColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            this.writeIntStream(dos, column.intIterator());
            dos.flush();
        }
    }

    private void writeColumn(String fileName, DateTimeColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            this.writeLongStream(dos, column.longIterator());
            dos.flush();
        }
    }

    private void writeColumn(String fileName, InstantColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            this.writeLongStream(dos, column.longIterator());
        }
    }

    private void writeColumn(String fileName, TimeColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            this.writeIntStream(dos, column.intIterator());
            dos.flush();
        }
    }

    private void writeColumn(String fileName, BooleanColumn column) throws IOException {
        try (DataOutputStream dos = this.columnOutputStream(fileName);){
            int i = 0;
            ByteIterator iterator = column.byteIterator();
            while (iterator.hasNext()) {
                dos.writeByte(iterator.nextByte());
                if (++i != 20000) continue;
                dos.flush();
                i = 0;
            }
            dos.flush();
        }
    }

    private void writeTableMetadata(Path filePath, SawMetadata metadata) throws IOException {
        Path metaDataPath = filePath.resolve("Metadata.json");
        try {
            Files.createFile(metaDataPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        try (FileOutputStream fOut = new FileOutputStream(metaDataPath.toFile());
             OutputStreamWriter myOutWriter = new OutputStreamWriter(fOut);){
            String output = metadata.toJson();
            myOutWriter.append(output);
        }
    }
}

