/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.saw;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.saw.ColumnMetadata;
import tech.tablesaw.table.Relation;

@Beta
public class TableMetadata {
    @JsonProperty(value="columnMetadata")
    private final List<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
    private String name;
    private int rowCount;

    TableMetadata(Relation table) {
        this.name = table.name();
        this.rowCount = table.rowCount();
        for (Column column : table.columns()) {
            ColumnMetadata metadata = new ColumnMetadata(column);
            this.columnMetadataList.add(metadata);
        }
    }

    protected TableMetadata() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMetadata metadata = (TableMetadata)o;
        return this.getRowCount() == metadata.getRowCount() && Objects.equal(this.getColumnMetadataList(), metadata.getColumnMetadataList()) && Objects.equal((Object)this.getName(), (Object)metadata.getName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getColumnMetadataList(), this.getName(), this.getRowCount()});
    }

    public String getName() {
        return this.name;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    List<ColumnMetadata> getColumnMetadataList() {
        return this.columnMetadataList;
    }

    public int columnCount() {
        return this.getColumnMetadataList().size();
    }

    public String shape() {
        return this.getName() + ": " + this.getRowCount() + " rows X " + this.columnCount() + " cols";
    }

    public List<String> columnNames() {
        return this.columnMetadataList.stream().map(ColumnMetadata::getName).collect(Collectors.toList());
    }

    public Table structure() {
        Table t = Table.create((String)("Structure of " + this.getName()));
        IntColumn index = IntColumn.indexColumn((String)"Index", (int)this.columnCount(), (int)0);
        StringColumn columnName = StringColumn.create((String)"Column Name", (int)this.columnCount());
        StringColumn columnType = StringColumn.create((String)"Column Type", (int)this.columnCount());
        t.addColumns(new Column[]{index});
        t.addColumns(new Column[]{columnName});
        t.addColumns(new Column[]{columnType});
        for (int i = 0; i < this.columnCount(); ++i) {
            ColumnMetadata column = this.columnMetadataList.get(i);
            columnType.set(i, column.getType());
            columnName.set(i, this.columnNames().get(i));
        }
        return t;
    }
}

