/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.saw;

import com.google.common.base.Preconditions;
import tech.tablesaw.io.saw.CompressionType;
import tech.tablesaw.io.saw.EncryptionType;

public class WriteOptions {
    private static final int DEFAULT_POOL_SIZE = 10;
    private int threadPoolSize = 10;
    private CompressionType compressionType = CompressionType.SNAPPY;
    private EncryptionType encryptionType = EncryptionType.NONE;

    public static WriteOptions defaultOptions() {
        return new WriteOptions();
    }

    public WriteOptions threadPoolSize(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        this.threadPoolSize = size;
        return this;
    }

    public WriteOptions compressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    public WriteOptions encryptionType(EncryptionType type) {
        this.encryptionType = type;
        return this;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }
}

