/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.BinaryPrefix;
import javax.measure.MeasurementError;
import javax.measure.MetricPrefix;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.AbstractUnitFormat;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.AnnotatedUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

public abstract class SimpleUnitFormat
extends AbstractUnitFormat {
    private static final Unit<?>[] METRIC_UNITS = new Unit[]{Units.AMPERE, Units.BECQUEREL, Units.CANDELA, Units.COULOMB, Units.FARAD, Units.GRAY, Units.HENRY, Units.HERTZ, Units.JOULE, Units.KATAL, Units.KELVIN, Units.LUMEN, Units.LUX, Units.METRE, Units.MOLE, Units.NEWTON, Units.OHM, Units.PASCAL, Units.RADIAN, Units.SECOND, Units.SIEMENS, Units.SIEVERT, Units.STERADIAN, Units.TESLA, Units.VOLT, Units.WATT, Units.WEBER};
    private static final String[] METRIC_PREFIX_SYMBOLS = Stream.of(MetricPrefix.values()).map(Prefix::getSymbol).collect(Collectors.toList()).toArray(new String[0]);
    private static final UnitConverter[] METRIC_PREFIX_CONVERTERS = Stream.of(MetricPrefix.values()).map(MultiplyConverter::ofPrefix).collect(Collectors.toList()).toArray(new UnitConverter[0]);
    private static final String[] BINARY_PREFIX_SYMBOLS = Stream.of(BinaryPrefix.values()).map(Prefix::getSymbol).collect(Collectors.toList()).toArray(new String[0]);
    private static final UnitConverter[] BINARY_PREFIX_CONVERTERS = Stream.of(BinaryPrefix.values()).map(MultiplyConverter::ofPrefix).collect(Collectors.toList()).toArray(new UnitConverter[0]);
    private static final String MU = "\u03bc";
    private static final Map<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();
    private static final DefaultFormat DEFAULT;
    private static final ASCIIFormat ASCII;

    public static SimpleUnitFormat getInstance() {
        return SimpleUnitFormat.getInstance(Flavor.Default);
    }

    public static SimpleUnitFormat getInstance(Flavor flavor) {
        switch (flavor) {
            case ASCII: {
                return ASCII;
            }
        }
        return DEFAULT;
    }

    protected SimpleUnitFormat() {
    }

    @Override
    public abstract Appendable format(Unit<?> var1, Appendable var2) throws IOException;

    public abstract Unit<? extends Quantity> parseProductUnit(CharSequence var1, ParsePosition var2) throws MeasurementParseException;

    public abstract Unit<? extends Quantity> parseSingleUnit(CharSequence var1, ParsePosition var2) throws MeasurementParseException;

    @Override
    public abstract void label(Unit<?> var1, String var2);

    public abstract void alias(Unit<?> var1, String var2);

    protected abstract boolean isValidIdentifier(String var1);

    public final StringBuffer format(Object unit, final StringBuffer toAppendTo, FieldPosition pos) {
        try {
            StringBuffer dest = toAppendTo;
            if (dest instanceof Appendable) {
                this.format((Unit)unit, dest);
            } else {
                this.format((Unit)unit, new Appendable(){

                    @Override
                    public Appendable append(char arg0) throws IOException {
                        toAppendTo.append(arg0);
                        return null;
                    }

                    @Override
                    public Appendable append(CharSequence arg0) throws IOException {
                        toAppendTo.append(arg0);
                        return null;
                    }

                    @Override
                    public Appendable append(CharSequence arg0, int arg1, int arg2) throws IOException {
                        toAppendTo.append(arg0.subSequence(arg1, arg2));
                        return null;
                    }
                });
            }
            return toAppendTo;
        }
        catch (IOException e) {
            throw new MeasurementError((Throwable)e);
        }
    }

    public final Unit<?> parseObject(String source, ParsePosition pos) throws MeasurementParseException {
        return this.parseProductUnit(source, pos);
    }

    private static String asciiPrefix(String prefix) {
        return "\u00b5".equals(prefix) ? "micro" : prefix;
    }

    private static String asciiSymbol(String s) {
        return "\u03a9".equals(s) ? "Ohm" : s;
    }

    protected static boolean isAllASCII(String input) {
        boolean isASCII = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f') continue;
            isASCII = false;
            break;
        }
        return isASCII;
    }

    protected static DefaultFormat initDefaultFormat(DefaultFormat defaultFormat) {
        int i;
        for (int i2 = 0; i2 < METRIC_UNITS.length; ++i2) {
            Unit<?> si = METRIC_UNITS[i2];
            String symbol = si instanceof BaseUnit ? ((BaseUnit)si).getSymbol() : ((AlternateUnit)si).getSymbol();
            defaultFormat.label(si, symbol);
            for (int j = 0; j < METRIC_PREFIX_SYMBOLS.length; ++j) {
                Unit u = si.prefix((Prefix)MetricPrefix.values()[j]);
                defaultFormat.label(u, METRIC_PREFIX_SYMBOLS[j] + symbol);
                if (!"\u00b5".equals(METRIC_PREFIX_SYMBOLS[j])) continue;
                defaultFormat.label(u, MU + symbol);
            }
        }
        defaultFormat.label(Units.GRAM, "g");
        block6: for (MetricPrefix prefix : MetricPrefix.values()) {
            switch (prefix) {
                case KILO: {
                    defaultFormat.label(Units.KILOGRAM, "kg");
                    continue block6;
                }
                case MICRO: {
                    defaultFormat.label(Units.GRAM.prefix((Prefix)prefix), prefix.getSymbol() + "g");
                    continue block6;
                }
                default: {
                    defaultFormat.label(Units.GRAM.prefix((Prefix)prefix), prefix.getSymbol() + "g");
                }
            }
        }
        defaultFormat.label(MetricPrefix.MICRO(Units.GRAM), MetricPrefix.MICRO.getSymbol() + "g");
        defaultFormat.alias(Units.OHM, "Ohm");
        for (i = 0; i < METRIC_PREFIX_SYMBOLS.length; ++i) {
            defaultFormat.alias(Units.OHM.prefix((Prefix)MetricPrefix.values()[i]), METRIC_PREFIX_SYMBOLS[i] + "Ohm");
        }
        defaultFormat.label(Units.CELSIUS, "\u2103");
        defaultFormat.alias(Units.CELSIUS, "\u00b0C");
        for (i = 0; i < METRIC_PREFIX_SYMBOLS.length; ++i) {
            defaultFormat.label(Units.CELSIUS.prefix((Prefix)MetricPrefix.values()[i]), METRIC_PREFIX_SYMBOLS[i] + "\u2103");
            defaultFormat.alias(Units.CELSIUS.prefix((Prefix)MetricPrefix.values()[i]), METRIC_PREFIX_SYMBOLS[i] + "\u00b0C");
        }
        defaultFormat.label(Units.PERCENT, "%");
        defaultFormat.label(Units.METRE, "m");
        defaultFormat.label(Units.SECOND, "s");
        defaultFormat.label(Units.MINUTE, "min");
        defaultFormat.label(Units.HOUR, "h");
        defaultFormat.label(Units.DAY, "day");
        defaultFormat.alias(Units.DAY, "d");
        defaultFormat.label(Units.WEEK, "week");
        defaultFormat.label(Units.YEAR, "year");
        defaultFormat.alias(Units.YEAR, "days365");
        defaultFormat.label(Units.MONTH, "mo");
        defaultFormat.alias(Units.MONTH, "mon");
        defaultFormat.alias(Units.MONTH, "month");
        defaultFormat.label(Units.KILOMETRE_PER_HOUR, "km/h");
        defaultFormat.label(Units.CUBIC_METRE, "\u33a5");
        defaultFormat.label(Units.LITRE, "l");
        for (MetricPrefix prefix : MetricPrefix.values()) {
            defaultFormat.label(Units.LITRE.prefix((Prefix)prefix), prefix.getSymbol() + "l");
        }
        defaultFormat.label(Units.NEWTON, "N");
        defaultFormat.label(Units.RADIAN, "rad");
        defaultFormat.label(AbstractUnit.ONE, "one");
        defaultFormat.alias(Units.SQUARE_METRE, "m2");
        defaultFormat.alias(Units.CUBIC_METRE, "m3");
        return defaultFormat;
    }

    protected static ASCIIFormat initASCIIFormat(ASCIIFormat asciiFormat) {
        int i;
        for (int i2 = 0; i2 < METRIC_UNITS.length; ++i2) {
            String symbol;
            Unit<?> si = METRIC_UNITS[i2];
            String string = symbol = si instanceof BaseUnit ? ((BaseUnit)si).getSymbol() : ((AlternateUnit)si).getSymbol();
            if (SimpleUnitFormat.isAllASCII(symbol)) {
                asciiFormat.label(si, symbol);
            }
            for (int j = 0; j < METRIC_PREFIX_SYMBOLS.length; ++j) {
                Unit u = si.prefix((Prefix)MetricPrefix.values()[j]);
                if (!"\u00b5".equals(METRIC_PREFIX_SYMBOLS[j])) continue;
                asciiFormat.label(u, "micro" + SimpleUnitFormat.asciiSymbol(symbol));
            }
        }
        asciiFormat.label(Units.GRAM, "g");
        block6: for (MetricPrefix prefix : MetricPrefix.values()) {
            switch (prefix) {
                case KILO: {
                    asciiFormat.label(Units.KILOGRAM, "kg");
                    continue block6;
                }
                case MICRO: {
                    asciiFormat.label(MetricPrefix.MICRO(Units.LITRE), "microg");
                    continue block6;
                }
                default: {
                    asciiFormat.label(Units.GRAM.prefix((Prefix)prefix), prefix.getSymbol() + "g");
                }
            }
        }
        asciiFormat.label(Units.OHM, "Ohm");
        for (i = 0; i < METRIC_PREFIX_SYMBOLS.length; ++i) {
            asciiFormat.label(Units.OHM.prefix((Prefix)MetricPrefix.values()[i]), SimpleUnitFormat.asciiPrefix(METRIC_PREFIX_SYMBOLS[i]) + "Ohm");
        }
        asciiFormat.label(Units.CELSIUS, "Celsius");
        for (i = 0; i < METRIC_PREFIX_SYMBOLS.length; ++i) {
            asciiFormat.label(Units.CELSIUS.prefix((Prefix)MetricPrefix.values()[i]), SimpleUnitFormat.asciiPrefix(METRIC_PREFIX_SYMBOLS[i]) + "Celsius");
        }
        asciiFormat.alias(Units.CELSIUS, "Cel");
        asciiFormat.label(Units.METRE, "m");
        asciiFormat.label(Units.SECOND, "s");
        asciiFormat.label(Units.KILOMETRE_PER_HOUR, "km/h");
        asciiFormat.alias(Units.SQUARE_METRE, "m2");
        asciiFormat.alias(Units.CUBIC_METRE, "m3");
        asciiFormat.label(Units.LITRE, "l");
        for (MetricPrefix prefix : MetricPrefix.values()) {
            if (prefix == MetricPrefix.MICRO) {
                asciiFormat.label(MetricPrefix.MICRO(Units.LITRE), "microL");
                continue;
            }
            asciiFormat.label(Units.LITRE.prefix((Prefix)prefix), prefix.getSymbol() + "L");
        }
        asciiFormat.label(Units.NEWTON, "N");
        asciiFormat.label(Units.RADIAN, "rad");
        asciiFormat.label(AbstractUnit.ONE, "one");
        return asciiFormat;
    }

    static {
        SYMBOL_TO_UNIT.put(MetricPrefix.MICRO.getSymbol() + "g", MetricPrefix.MICRO(Units.GRAM));
        SYMBOL_TO_UNIT.put("\u03bcg", MetricPrefix.MICRO(Units.GRAM));
        SYMBOL_TO_UNIT.put("\u03bcg", MetricPrefix.MICRO(Units.GRAM));
        DEFAULT = SimpleUnitFormat.initDefaultFormat(new DefaultFormat());
        ASCII = SimpleUnitFormat.initASCIIFormat(new ASCIIFormat());
    }

    protected static final class ASCIIFormat
    extends DefaultFormat {
        protected ASCIIFormat() {
        }

        @Override
        protected String nameFor(Unit<?> unit) {
            String name = (String)this.unitToName.get(unit);
            if (name != null) {
                return name;
            }
            return DEFAULT.nameFor(unit);
        }

        @Override
        protected Unit<?> unitFor(String name) {
            Unit unit = (Unit)this.nameToUnit.get(name);
            if (unit != null) {
                return unit;
            }
            return DEFAULT.unitFor(name);
        }

        @Override
        public String toString() {
            return "SimpleUnitFormat - ASCII";
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            for (int i = 0; i < productUnit.getUnitCount(); ++i) {
                if (i != 0) {
                    appendable.append('*');
                }
                name = this.nameFor(productUnit.getUnit(i));
                int pow = productUnit.getUnitPow(i);
                int root = productUnit.getUnitRoot(i);
                appendable.append(name);
                if (pow == 1 && root == 1) continue;
                appendable.append('^');
                appendable.append(String.valueOf(pow));
                if (root == 1) continue;
                appendable.append(':');
                appendable.append(String.valueOf(root));
            }
            return appendable;
        }

        @Override
        protected boolean isValidIdentifier(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            return ASCIIFormat.isUnitIdentifierPart(name.charAt(0)) && ASCIIFormat.isAllASCII(name);
        }
    }

    protected static class DefaultFormat
    extends SimpleUnitFormat {
        protected final Map<String, Unit<?>> nameToUnit = new HashMap();
        protected final Map<Unit<?>, String> unitToName = new HashMap();

        protected DefaultFormat() {
        }

        public String toString() {
            return "SimpleUnitFormat";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void label(Unit<?> unit, String label) {
            if (!this.isValidIdentifier(label)) {
                throw new IllegalArgumentException("Label: " + label + " is not a valid identifier.");
            }
            DefaultFormat defaultFormat = this;
            synchronized (defaultFormat) {
                this.nameToUnit.put(label, unit);
                this.unitToName.put(unit, label);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alias(Unit<?> unit, String alias) {
            if (!this.isValidIdentifier(alias)) {
                throw new IllegalArgumentException("Alias: " + alias + " is not a valid identifier.");
            }
            DefaultFormat defaultFormat = this;
            synchronized (defaultFormat) {
                this.nameToUnit.put(alias, unit);
            }
        }

        @Override
        protected boolean isValidIdentifier(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            return DefaultFormat.isUnitIdentifierPart(name.charAt(0));
        }

        protected static boolean isUnitIdentifierPart(char ch) {
            return Character.isLetter(ch) || !Character.isWhitespace(ch) && !Character.isDigit(ch) && ch != '\u00b7' && ch != '*' && ch != '/' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != '\u00b9' && ch != '\u00b2' && ch != '\u00b3' && ch != '^' && ch != '+' && ch != '-';
        }

        protected String nameFor(Unit<?> unit) {
            String label = this.unitToName.get(unit);
            if (label != null) {
                return label;
            }
            if (unit instanceof BaseUnit) {
                return ((BaseUnit)unit).getSymbol();
            }
            if (unit instanceof AlternateUnit) {
                return ((AlternateUnit)unit).getSymbol();
            }
            if (unit instanceof TransformedUnit) {
                TransformedUnit tfmUnit = (TransformedUnit)unit;
                if (tfmUnit.getSymbol() != null) {
                    return tfmUnit.getSymbol();
                }
                Unit baseUnit = tfmUnit.getParentUnit();
                UnitConverter cvtr = tfmUnit.getConverter();
                StringBuilder result = new StringBuilder();
                String baseUnitName = baseUnit.toString();
                String prefix = this.prefixFor(cvtr);
                if (baseUnitName.indexOf(183) >= 0 || baseUnitName.indexOf(42) >= 0 || baseUnitName.indexOf(47) >= 0) {
                    result.append('(');
                    result.append(baseUnitName);
                    result.append(')');
                } else {
                    result.append(baseUnitName);
                }
                if (prefix != null) {
                    result.insert(0, prefix);
                } else if (cvtr instanceof AddConverter) {
                    result.append('+');
                    result.append(((AddConverter)cvtr).getOffset());
                } else if (cvtr instanceof MultiplyConverter) {
                    Number scaleFactor = ((MultiplyConverter)cvtr).getFactor();
                    if (scaleFactor instanceof RationalNumber) {
                        RationalNumber rational = (RationalNumber)scaleFactor;
                        RationalNumber reciprocal = rational.reciprocal();
                        if (reciprocal.isInteger()) {
                            result.append('/');
                            result.append(reciprocal.toString());
                        } else {
                            result.append('*');
                            result.append(scaleFactor);
                        }
                    } else {
                        result.append('*');
                        result.append(scaleFactor);
                    }
                } else {
                    return "[" + baseUnit + "?]";
                }
                return result.toString();
            }
            if (unit instanceof AnnotatedUnit) {
                AnnotatedUnit annotatedUnit = (AnnotatedUnit)unit;
                StringBuilder annotable = new StringBuilder(this.nameFor(annotatedUnit.getActualUnit()));
                if (annotatedUnit.getAnnotation() != null) {
                    annotable.append('{');
                    annotable.append(annotatedUnit.getAnnotation());
                    annotable.append('}');
                }
                return annotable.toString();
            }
            return null;
        }

        protected String prefixFor(UnitConverter converter) {
            for (int i = 0; i < METRIC_PREFIX_CONVERTERS.length; ++i) {
                if (!METRIC_PREFIX_CONVERTERS[i].equals(converter)) continue;
                return METRIC_PREFIX_SYMBOLS[i];
            }
            for (int j = 0; j < BINARY_PREFIX_CONVERTERS.length; ++j) {
                if (!BINARY_PREFIX_CONVERTERS[j].equals(converter)) continue;
                return BINARY_PREFIX_SYMBOLS[j];
            }
            return null;
        }

        protected Unit<?> unitFor(String name) {
            Unit unit = this.nameToUnit.get(name);
            if (unit != null) {
                return unit;
            }
            unit = (Unit)SYMBOL_TO_UNIT.get(name);
            return unit;
        }

        @Override
        public Unit<? extends Quantity> parseSingleUnit(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
            int startIndex = pos.getIndex();
            String name = DefaultFormat.readIdentifier(csq, pos);
            Unit<?> unit = this.unitFor(name);
            DefaultFormat.check(unit != null, name + " not recognized", csq, startIndex);
            return unit;
        }

        @Override
        public Unit<? extends Quantity> parseProductUnit(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
            Unit<?> result = null;
            if (csq == null) {
                throw new MeasurementParseException("Cannot parse null", csq, pos.getIndex());
            }
            result = this.unitFor(csq.toString());
            if (result != null) {
                return result;
            }
            result = AbstractUnit.ONE;
            Token token = DefaultFormat.nextToken(csq, pos);
            switch (token) {
                case IDENTIFIER: {
                    result = this.parseSingleUnit(csq, pos);
                    break;
                }
                case OPEN_PAREN: {
                    pos.setIndex(pos.getIndex() + 1);
                    result = this.parseProductUnit(csq, pos);
                    token = DefaultFormat.nextToken(csq, pos);
                    DefaultFormat.check(token == Token.CLOSE_PAREN, "')' expected", csq, pos.getIndex());
                    pos.setIndex(pos.getIndex() + 1);
                    break;
                }
            }
            token = DefaultFormat.nextToken(csq, pos);
            while (true) {
                switch (token) {
                    case EXPONENT: {
                        Exponent e = DefaultFormat.readExponent(csq, pos);
                        if (e.pow != 1) {
                            result = result.pow(e.pow);
                        }
                        if (e.root == 1) break;
                        result = result.root(e.root);
                        break;
                    }
                    case MULTIPLY: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = DefaultFormat.nextToken(csq, pos);
                        if (token == Token.INTEGER) {
                            long n = DefaultFormat.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.multiply((double)n);
                            break;
                        }
                        if (token == Token.FLOAT) {
                            double d = DefaultFormat.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.multiply(d);
                            break;
                        }
                        result = result.multiply(this.parseProductUnit(csq, pos));
                        break;
                    }
                    case DIVIDE: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = DefaultFormat.nextToken(csq, pos);
                        if (token == Token.INTEGER) {
                            long n = DefaultFormat.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.divide((double)n);
                            break;
                        }
                        if (token == Token.FLOAT) {
                            double d = DefaultFormat.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.divide(d);
                            break;
                        }
                        result = result.divide(this.parseProductUnit(csq, pos));
                        break;
                    }
                    case PLUS: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = DefaultFormat.nextToken(csq, pos);
                        if (token == Token.INTEGER) {
                            long n = DefaultFormat.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.shift((double)n);
                            break;
                        }
                        if (token == Token.FLOAT) {
                            double d = DefaultFormat.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.shift(d);
                            break;
                        }
                        throw new MeasurementParseException("not a number", csq, pos.getIndex());
                    }
                    case EOF: 
                    case CLOSE_PAREN: {
                        return result;
                    }
                    default: {
                        throw new MeasurementParseException("unexpected token " + (Object)((Object)token), csq, pos.getIndex());
                    }
                }
                token = DefaultFormat.nextToken(csq, pos);
            }
        }

        private static Token nextToken(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            while (pos.getIndex() < length) {
                char c = csq.charAt(pos.getIndex());
                if (DefaultFormat.isUnitIdentifierPart(c)) {
                    return Token.IDENTIFIER;
                }
                if (c == '(') {
                    return Token.OPEN_PAREN;
                }
                if (c == ')') {
                    return Token.CLOSE_PAREN;
                }
                if (c == '^' || c == '\u00b9' || c == '\u00b2' || c == '\u00b3') {
                    return Token.EXPONENT;
                }
                if (c == '*') {
                    if (csq.length() == pos.getIndex() + 1) {
                        throw new MeasurementParseException("unexpected token " + (Object)((Object)Token.EOF), csq, pos.getIndex());
                    }
                    char c2 = csq.charAt(pos.getIndex() + 1);
                    return c2 == '*' ? Token.EXPONENT : Token.MULTIPLY;
                }
                if (c == '\u00b7') {
                    return Token.MULTIPLY;
                }
                if (c == '/') {
                    return Token.DIVIDE;
                }
                if (c == '+') {
                    return Token.PLUS;
                }
                if (c == '-' || Character.isDigit(c)) {
                    int index = pos.getIndex() + 1;
                    while (index < length && (Character.isDigit(c) || c == '-' || c == '.' || c == 'E')) {
                        if ((c = csq.charAt(index++)) != '.') continue;
                        return Token.FLOAT;
                    }
                    return Token.INTEGER;
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            return Token.EOF;
        }

        private static void check(boolean expr, String message, CharSequence csq, int index) throws MeasurementParseException {
            if (!expr) {
                throw new MeasurementParseException((CharSequence)(message + " (in " + csq + " at index " + index + ")"), index);
            }
        }

        private static Exponent readExponent(CharSequence csq, ParsePosition pos) {
            char c = csq.charAt(pos.getIndex());
            if (c == '^') {
                pos.setIndex(pos.getIndex() + 1);
            } else if (c == '*') {
                pos.setIndex(pos.getIndex() + 2);
            }
            int length = csq.length();
            int pow = 0;
            boolean isPowNegative = false;
            boolean parseRoot = false;
            block13: while (pos.getIndex() < length) {
                c = csq.charAt(pos.getIndex());
                switch (c) {
                    case '-': {
                        isPowNegative = true;
                        break;
                    }
                    case '\u00b9': {
                        pow = pow * 10 + 1;
                        break;
                    }
                    case '\u00b2': {
                        pow = pow * 10 + 2;
                        break;
                    }
                    case '\u00b3': {
                        pow = pow * 10 + 3;
                        break;
                    }
                    case ':': {
                        parseRoot = true;
                        break block13;
                    }
                    default: {
                        if (c < '0' || c > '9') break block13;
                        pow = pow * 10 + (c - 48);
                    }
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            if (pow == 0) {
                pow = 1;
            }
            int root = 0;
            boolean isRootNegative = false;
            if (parseRoot) {
                pos.setIndex(pos.getIndex() + 1);
                block14: while (pos.getIndex() < length) {
                    c = csq.charAt(pos.getIndex());
                    switch (c) {
                        case '-': {
                            isRootNegative = true;
                            break;
                        }
                        case '\u00b9': {
                            root = root * 10 + 1;
                            break;
                        }
                        case '\u00b2': {
                            root = root * 10 + 2;
                            break;
                        }
                        case '\u00b3': {
                            root = root * 10 + 3;
                            break;
                        }
                        default: {
                            if (c < '0' || c > '9') break block14;
                            root = root * 10 + (c - 48);
                        }
                    }
                    pos.setIndex(pos.getIndex() + 1);
                }
            }
            if (root == 0) {
                root = 1;
            }
            return new Exponent(isPowNegative ? -pow : pow, isRootNegative ? -root : root);
        }

        private static long readLong(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            int result = 0;
            boolean isNegative = false;
            while (pos.getIndex() < length) {
                char c = csq.charAt(pos.getIndex());
                if (c == '-') {
                    isNegative = true;
                } else {
                    if (c < '0' || c > '9') break;
                    result = result * 10 + (c - 48);
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            return isNegative ? (long)(-result) : (long)result;
        }

        private static double readDouble(CharSequence csq, ParsePosition pos) {
            int end;
            int length = csq.length();
            int start = pos.getIndex();
            for (end = start + 1; end < length && "0123456789+-.E".indexOf(csq.charAt(end)) >= 0; ++end) {
            }
            pos.setIndex(end + 1);
            return Double.parseDouble(csq.subSequence(start, end).toString());
        }

        private static String readIdentifier(CharSequence csq, ParsePosition pos) {
            int start;
            int length = csq.length();
            int i = start = pos.getIndex();
            while (++i < length && DefaultFormat.isUnitIdentifierPart(csq.charAt(i))) {
            }
            pos.setIndex(i);
            return csq.subSequence(start, i).toString();
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            int root;
            int pow;
            int i;
            ProductUnit powerUnit;
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            if (productUnit.getUnitCount() == 1 && productUnit.getUnit(0) instanceof ProductUnit && this.nameFor(powerUnit = (ProductUnit)productUnit.getUnit(0)) == null) {
                return this.format(ProductUnit.ofPow(powerUnit, productUnit.getUnitPow(0)), appendable);
            }
            int invNbr = 0;
            boolean start = true;
            for (i = 0; i < productUnit.getUnitCount(); ++i) {
                pow = productUnit.getUnitPow(i);
                if (pow >= 0) {
                    if (!start) {
                        appendable.append('\u00b7');
                    }
                    name = this.nameFor(productUnit.getUnit(i));
                    root = productUnit.getUnitRoot(i);
                    DefaultFormat.append(appendable, name, pow, root);
                    start = false;
                    continue;
                }
                ++invNbr;
            }
            if (invNbr != 0) {
                if (start) {
                    appendable.append('1');
                }
                appendable.append('/');
                if (invNbr > 1) {
                    appendable.append('(');
                }
                start = true;
                for (i = 0; i < productUnit.getUnitCount(); ++i) {
                    pow = productUnit.getUnitPow(i);
                    if (pow >= 0) continue;
                    name = this.nameFor(productUnit.getUnit(i));
                    root = productUnit.getUnitRoot(i);
                    if (!start) {
                        appendable.append('\u00b7');
                    }
                    DefaultFormat.append(appendable, name, -pow, root);
                    start = false;
                }
                if (invNbr > 1) {
                    appendable.append(')');
                }
            }
            return appendable;
        }

        private static void append(Appendable appendable, CharSequence symbol, int pow, int root) throws IOException {
            appendable.append(symbol);
            if (pow != 1 || root != 1) {
                if (pow == 2 && root == 1) {
                    appendable.append('\u00b2');
                } else if (pow == 3 && root == 1) {
                    appendable.append('\u00b3');
                } else {
                    appendable.append('^');
                    appendable.append(String.valueOf(pow));
                    if (root != 1) {
                        appendable.append(':');
                        appendable.append(String.valueOf(root));
                    }
                }
            }
        }

        public Unit<?> parse(CharSequence csq) throws MeasurementParseException {
            return this.parse(csq, 0);
        }

        @Override
        protected Unit<?> parse(CharSequence csq, int index) throws IllegalArgumentException {
            return this.parse(csq, new ParsePosition(index));
        }

        @Override
        public Unit<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
            return this.parseObject(csq.toString(), cursor);
        }

        private static enum Token {
            EOF,
            IDENTIFIER,
            OPEN_PAREN,
            CLOSE_PAREN,
            EXPONENT,
            MULTIPLY,
            DIVIDE,
            PLUS,
            INTEGER,
            FLOAT;

        }
    }

    private static class Exponent {
        public final int pow;
        public final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }

    public static enum Flavor {
        Default,
        ASCII;

    }
}

