/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.Tool;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.annotations.Test;
import org.testng.reporters.VerboseReporter;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import tech.units.tck.TCKSetup;
import tech.units.tck.tests.FundamentalTypesTest;
import tech.units.tck.tests.format.QuantityFormatTest;
import tech.units.tck.tests.format.UnitFormatTest;
import tech.units.tck.tests.quantity.QuantityInterfaceTest;
import tech.units.tck.tests.quantity.QuantityTypesTest;
import tech.units.tck.tests.spi.ObtainingQuantiesTest;
import tech.units.tck.tests.spi.ObtainingUnitsTest;
import tech.units.tck.tests.spi.QuantityFactoryTest;
import tech.units.tck.tests.spi.ServiceProviderTest;
import tech.units.tck.tests.spi.ServicesTest;
import tech.units.tck.tests.spi.SystemOfUnitsTest;
import tech.units.tck.tests.unit.PrefixInterfaceTest;
import tech.units.tck.tests.unit.UnitConversionTest;
import tech.units.tck.tests.unit.UnitDimensionTest;
import tech.units.tck.tests.unit.UnitInterfaceTest;
import tech.units.tck.util.TestGroups;
import tech.uom.lib.common.function.Versioned;

public class TCKRunner
extends XmlSuite
implements Tool,
Versioned<String> {
    public static final String SECTION_PREFIX = "Section ";
    public static final String MEASURE_PACKAGE = "javax.measure";
    public static final String SPEC_ID = "JSR 385";
    public static final String SPEC_VERSION = "2.2";
    private static final String TCK_VERSION = "2.2";
    private static final String MSG_FAILED = "[FAILED]  ";
    private final TestGroups.Profile profile;

    public TCKRunner() {
        this.setName("JSR 385 - TCK 2.2");
        XmlTest test = new XmlTest((XmlSuite)this);
        this.profile = TestGroups.Profile.valueOf(System.getProperty("tech.units.tck.profile", TestGroups.Profile.FULL.name()).toUpperCase());
        for (String group : this.profile.getGroups()) {
            test.addIncludedGroup(group);
        }
        test.setName("TCK/Test Setup");
        ArrayList<XmlClass> classes = new ArrayList<XmlClass>();
        classes.add(new XmlClass(TCKSetup.class));
        classes.add(new XmlClass(FundamentalTypesTest.class));
        classes.add(new XmlClass(UnitInterfaceTest.class));
        classes.add(new XmlClass(UnitConversionTest.class));
        classes.add(new XmlClass(PrefixInterfaceTest.class));
        classes.add(new XmlClass(UnitDimensionTest.class));
        classes.add(new XmlClass(QuantityInterfaceTest.class));
        classes.add(new XmlClass(QuantityTypesTest.class));
        classes.add(new XmlClass(UnitFormatTest.class));
        classes.add(new XmlClass(QuantityFormatTest.class));
        classes.add(new XmlClass(QuantityFactoryTest.class));
        classes.add(new XmlClass(SystemOfUnitsTest.class));
        classes.add(new XmlClass(ServiceProviderTest.class));
        classes.add(new XmlClass(ServicesTest.class));
        classes.add(new XmlClass(ObtainingUnitsTest.class));
        classes.add(new XmlClass(ObtainingQuantiesTest.class));
        test.setXmlClasses(classes);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... args) {
        System.out.println("-- JSR 385 TCK started --");
        System.out.println("Profile: " + this.profile.getDescription());
        ArrayList<TCKRunner> suites = new ArrayList<TCKRunner>();
        suites.add(new TCKRunner());
        TestNG tng = new TestNG();
        tng.setXmlSuites(suites);
        String outDir = System.getProperty("tech.units.tck.outputDir", "./target/tck-output");
        tng.setOutputDirectory(outDir);
        String verbose = System.getProperty("tech.units.tck.verbose");
        if ("true".equalsIgnoreCase(verbose)) {
            tng.addListener((ITestNGListener)new VerboseReporter("[VerboseUoM] "));
        }
        String reportFile = System.getProperty("tech.units.tck.reportFile", "./target/tck-results.txt");
        File file = new File(reportFile);
        Reporter rep = new Reporter(this.profile, file);
        System.out.println("Writing to file " + file.getAbsolutePath() + " ...");
        tng.addListener((ITestNGListener)rep);
        tng.run();
        rep.writeSummary();
        System.out.println("-- JSR 385 TCK finished --");
        return 0;
    }

    public String getVersion() {
        return "2.2";
    }

    @Override
    public final Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(new HashSet<SourceVersion>(Arrays.asList(SourceVersion.RELEASE_8)));
    }

    public static final void main(String ... args) {
        if (args.length > 0 && "-version".equalsIgnoreCase(args[0])) {
            TCKRunner.showVersion();
        } else {
            TCKRunner.showHelp();
        }
    }

    private static void showHelp() {
        StringWriter consoleWriter = new StringWriter(1000);
        consoleWriter.write("*****************************************************************************************\n");
        consoleWriter.write("**** JSR 385 - Units of Measurement, Technical Compatibility Kit, version 2.2\n");
        consoleWriter.write("*****************************************************************************************\n\n");
        consoleWriter.write("Usage:\n");
        consoleWriter.write("To run the TCK, execute TestNG with Maven or a similar build tool.\n\n");
        consoleWriter.write("E.g. by running \"mvn test\" with this POM.\n\n");
        consoleWriter.write("You may use the following system properties to override the default behavior:\n");
        consoleWriter.write("-Dtech.units.tck.profile=<profile> to select the desired profile from these available JSR 385 profiles:\n");
        for (TestGroups.Profile p : TestGroups.Profile.values()) {
            consoleWriter.write("   " + p.name() + " - " + p.getDescription() + (p.isDefault() ? " (the default profile)\n" : "\n"));
        }
        consoleWriter.write("-Dtech.units.tck.outputDir=<directory> to set the output directory of your choice.\n");
        consoleWriter.write("-Dtech.units.tck.reportFile=<file> to set the TCK result file directory of your choice.\n");
        consoleWriter.write("-Dtech.units.tck.verbose=true/false to toggle the TCK verbose option for additional test output. The default is \"false\"\n");
        System.out.println(consoleWriter);
    }

    private static void showVersion() {
        System.out.println("JSR 385 - Units of Measurement, Technical Compatibility Kit, version \"2.2\"\n");
    }

    private static final class Reporter
    extends TestListenerAdapter {
        private int count = 0;
        private int skipped = 0;
        private int failed = 0;
        private int success = 0;
        private final StringWriter consoleWriter = new StringWriter(3000);
        private FileWriter fileWriter;

        public Reporter(TestGroups.Profile profile, File file) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.fileWriter = new FileWriter(file);
                this.fileWriter.write("*****************************************************************************************\n");
                this.fileWriter.write("**** JSR 385 - Units of Measurement, Technical Compatibility Kit, version 2.2\n");
                this.fileWriter.write("*****************************************************************************************\n\n");
                this.fileWriter.write("Executed on " + new Date() + "\n");
                this.fileWriter.write("Operating System " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ") \n");
                this.fileWriter.write("Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ") \n");
                this.fileWriter.write("Using " + profile.getDescription() + " profile\n\n");
                this.consoleWriter.write("*****************************************************************************************\n");
                this.consoleWriter.write("**** JSR 385 - Units of Measurement, Technical Compatibility Kit, version 2.2\n");
                this.consoleWriter.write("*****************************************************************************************\n\n");
                this.consoleWriter.write("Executed on " + new Date() + "\n");
                this.consoleWriter.write("Using " + profile.getDescription() + " profile\n\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }

        public void onTestFailure(ITestResult tr) {
            ++this.failed;
            ++this.count;
            String location = tr.getTestClass().getRealClass().getSimpleName() + '#' + tr.getMethod().getMethodName();
            try {
                Method realTestMethod = tr.getMethod().getConstructorOrMethod().getMethod();
                Test testAnnot = realTestMethod.getAnnotation(Test.class);
                if (testAnnot != null && testAnnot.description() != null && !testAnnot.description().isEmpty()) {
                    if (tr.getThrowable() != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter w = new PrintWriter(sw);
                        tr.getThrowable().printStackTrace(w);
                        w.flush();
                        this.log(TCKRunner.MSG_FAILED + testAnnot.description() + "(" + location + "):\n" + sw.toString());
                    } else {
                        this.log(TCKRunner.MSG_FAILED + testAnnot.description() + "(" + location + ")");
                    }
                } else if (tr.getThrowable() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter w = new PrintWriter(sw);
                    tr.getThrowable().printStackTrace(w);
                    w.flush();
                    this.log(TCKRunner.MSG_FAILED + location + ":\n" + sw.toString());
                } else {
                    this.log(TCKRunner.MSG_FAILED + location);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Error", e);
            }
        }

        public void onTestSkipped(ITestResult tr) {
            ++this.skipped;
            ++this.count;
            String location = tr.getTestClass().getRealClass().getSimpleName() + '#' + tr.getMethod().getMethodName();
            try {
                Method realTestMethod = tr.getMethod().getConstructorOrMethod().getMethod();
                Test specAssert = realTestMethod.getAnnotation(Test.class);
                if (specAssert != null && specAssert.description() != null && !specAssert.description().isEmpty()) {
                    this.log("[SKIPPED] " + specAssert.description() + "(" + location + ")");
                } else {
                    this.log("[SKIPPED] " + location);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Error", e);
            }
        }

        public void onTestSuccess(ITestResult tr) {
            ++this.success;
            ++this.count;
            String location = tr.getTestClass().getRealClass().getSimpleName() + '#' + tr.getMethod().getMethodName();
            try {
                Method realTestMethod = tr.getMethod().getConstructorOrMethod().getMethod();
                Test specAssert = realTestMethod.getAnnotation(Test.class);
                if (specAssert != null && specAssert.description() != null && !specAssert.description().isEmpty()) {
                    this.log("[SUCCESS] " + specAssert.description() + "(" + location + ")");
                } else {
                    this.log("[SUCCESS] " + location);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Error", e);
            }
        }

        private void log(String text) throws IOException {
            this.fileWriter.write(text);
            this.fileWriter.write(10);
            this.consoleWriter.write(text);
            this.consoleWriter.write(10);
        }

        public void writeSummary() {
            try {
                this.log("\nJSR 385 TCK version 2.2 Summary");
                this.log("-------------------------------------------------------");
                this.log("\nTOTAL TESTS EXECUTED : " + this.count);
                this.log("TOTAL TESTS SKIPPED  : " + this.skipped);
                this.log("TOTAL TESTS SUCCESS  : " + this.success);
                this.log("TOTAL TESTS FAILED   : " + this.failed);
                this.fileWriter.flush();
                this.fileWriter.close();
                this.consoleWriter.flush();
                System.out.println();
                System.out.println(this.consoleWriter);
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Error", e);
            }
        }
    }
}

