/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.number.OrderingComparison;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;

@SpecVersion(spec="JSR 385", version="2.2")
public class FundamentalTypesTest {
    private static final String SECTION = "4.1";

    @Test(groups={"core"}, description="4.1 Ensure at least one Unit implementation is available/registered.")
    @SpecAssertion(section="4.1", id="41-A1")
    public void testEnsureGotUnit() {
        Assert.assertNotNull((Object)TCKSetup.getConfiguration(), (String)"TCK Configuration not available.");
        MatcherAssert.assertThat((String)"No Unit implementation found.", TCKSetup.getConfiguration().getUnitClasses(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }

    @Test(groups={"core"}, description="4.1 Ensure at least one Dimension implementation is available/registered.")
    @SpecAssertion(section="4.1", id="41-A2")
    public void testEnsureHasDimension() {
        Assert.assertNotNull((Object)TCKSetup.getConfiguration(), (String)"TCK Configuration not available.");
        MatcherAssert.assertThat((String)"No Dimension implementation found.", TCKSetup.getConfiguration().getDimensionClasses(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }

    @Test(groups={"core"}, description="4.1 Ensure at least one Prefix implementation is available/registered.")
    @SpecAssertion(section="4.1", id="41-A3")
    public void testEnsureHasPrefix() {
        Assert.assertNotNull((Object)TCKSetup.getConfiguration(), (String)"TCK Configuration not available.");
        MatcherAssert.assertThat((String)"No Prefix implementation found.", TCKSetup.getConfiguration().getPrefixClasses(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)TCKSetup.getConfiguration().getPrefixClasses().size(), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
    }

    @Test(groups={"core"}, description="4.1 Ensure at least one Quantity implementation is available/registered.")
    @SpecAssertion(section="4.1", id="41-A4")
    public void testEnsureHasQuantity() {
        Assert.assertNotNull((Object)TCKSetup.getConfiguration(), (String)"TCK Configuration not available.");
        MatcherAssert.assertThat((String)"No Quantity implementation found.", TCKSetup.getConfiguration().getQuantityClasses(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }
}

