/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;

@SpecVersion(spec="JSR 385", version="2.2")
public class TCKSetupTest {
    private static final String SECTION_NUM = "0";

    @Test(groups={"core"}, description="TCK Setup: ensure TCK Configuration is registered and available.")
    @SpecAssertion(section="0", id="Setup", note="Tests that a TestConfiguration is registered with the JDK ServiceLoader.")
    public void testTestSetup() {
        Assert.assertNotNull((Object)TCKSetup.getConfiguration(), (String)"TCK Configuration not available.");
    }

    @Test(groups={"core"}, description="Checks that Quantity classes are registered for testing.")
    @SpecAssertion(section="0", id="Setup", note="Checks that TestConfiguration.getQuantityClasses() returns a non empty collection of quantity implementations")
    public void testQuantityConfiguration() {
        Collection<Class> quantityClasses = TCKSetup.getConfiguration().getQuantityClasses();
        Assert.assertNotNull(quantityClasses, (String)"TCK Test Configuration quantity classes are null.");
        MatcherAssert.assertThat((String)"TCK Test Configuration quantity classes are missing.", quantityClasses, (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }
}

