/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.format;

import javax.measure.Quantity;
import javax.measure.format.QuantityFormat;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;
import tech.units.tck.util.TestUtils;

@SpecVersion(spec="JSR 385", version="2.2")
public class QuantityFormatTest {
    private static final String SECTION_NUM = "4.6";

    @Test(groups={"format"}, description="4.6 Ensure at least one QuantityFormat implementation is available/registered.")
    @SpecAssertion(section="4.6", id="46-A1")
    public void testEnsureGotQuantityFormat() {
        Assert.assertNotNull((Object)TCKSetup.getConfiguration(), (String)"TCK Configuration not available.");
        MatcherAssert.assertThat((String)"No QuantityFormat implementation found.", TCKSetup.getConfiguration().getQuantityFormats4Test(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }

    @Test(groups={"format"}, description="4.6 Ensure the format() operation is implemented.")
    @SpecAssertion(section="4.6", id="46-A2")
    public void testQuantityFormatFormat() {
        for (QuantityFormat format : TCKSetup.getConfiguration().getQuantityFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.6", type, false, Appendable.class, "format", Quantity.class, Appendable.class);
        }
    }

    @Test(groups={"format"}, description="4.6 Ensure the appendable format() operation is implemented.")
    @SpecAssertion(section="4.6", id="46-A3")
    public void testQuantityFormatFormatAppendable() {
        for (QuantityFormat format : TCKSetup.getConfiguration().getQuantityFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.6", type, false, Appendable.class, "format", Quantity.class, Appendable.class);
        }
    }

    @Test(groups={"format"}, description="4.6 Ensure the isLocaleSensitive() method is implemented.")
    @SpecAssertion(section="4.6", id="46-A4")
    public void testQuantityFormatFormatIsLocalSensitive() {
        for (QuantityFormat format : TCKSetup.getConfiguration().getQuantityFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.6", type, "isLocaleSensitive", false);
        }
    }

    @Test(groups={"format"}, description="4.6 Ensure the parse() operation is implemented.")
    @SpecAssertion(section="4.6", id="46-A5")
    public void testQuantityFormatParse() {
        for (QuantityFormat format : TCKSetup.getConfiguration().getQuantityFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.6", type, "parse", true);
        }
    }
}

