/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.format;

import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;
import tech.units.tck.util.TestUtils;

@SpecVersion(spec="JSR 385", version="2.2")
public class UnitFormatTest {
    private static final String SECTION_NUM = "4.5";

    @Test(groups={"format"}, description="4.5 Ensure at least one UnitFormat implementation is available/registered.")
    @SpecAssertion(section="4.5", id="45-A1")
    public void testEnsureGotUnitFormat() {
        Assert.assertNotNull((Object)TCKSetup.getConfiguration(), (String)"TCK Configuration not available.");
        MatcherAssert.assertThat((String)"No UnitFormat implementation found.", TCKSetup.getConfiguration().getUnitFormats4Test(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }

    @Test(groups={"format"}, description="4.5 Ensure the format() operation is implemented.")
    @SpecAssertion(section="4.5", id="45-A2")
    public void testUnitFormatFormat() {
        for (UnitFormat format : TCKSetup.getConfiguration().getUnitFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.5", type, false, String.class, "format", Unit.class);
        }
    }

    @Test(groups={"format"}, description="4.5 Ensure the appendable format() operation is implemented.")
    @SpecAssertion(section="4.5", id="45-A3")
    public void testUnitFormatFormatAppendable() {
        for (UnitFormat format : TCKSetup.getConfiguration().getUnitFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.5", type, false, Appendable.class, "format", Unit.class, Appendable.class);
        }
    }

    @Test(groups={"format"}, description="4.5 Ensure the isLocaleSensitive() method is implemented.")
    @SpecAssertion(section="4.5", id="45-A4")
    public void testUnitFormatFormatIsLocalSensitive() {
        for (UnitFormat format : TCKSetup.getConfiguration().getUnitFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.5", type, "isLocaleSensitive", false);
        }
    }

    @Test(groups={"format"}, description="4.5 Ensure the label() operation is implemented.")
    @SpecAssertion(section="4.5", id="45-A5")
    public void testUnitFormatLabel() {
        for (UnitFormat format : TCKSetup.getConfiguration().getUnitFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.5", type, "label", true);
        }
    }

    @Test(groups={"format"}, description="4.5 Ensure the parse() operation is implemented.")
    @SpecAssertion(section="4.5", id="45-A6")
    public void testUnitFormatParse() {
        for (UnitFormat format : TCKSetup.getConfiguration().getUnitFormats4Test()) {
            Class<?> type = format.getClass();
            TestUtils.testHasPublicMethod("Section 4.5", type, "parse", true);
        }
    }
}

