/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.spi;

import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.QuantityFormat;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.testng.Assert;
import org.testng.annotations.Test;
import tech.units.tck.util.TestUtils;

@SpecVersion(spec="JSR 385", version="2.2")
public class ObtainingQuantiesTest {
    private static final String SECTION_NUM = "5.6.1";

    @Test(groups={"spi"}, description="5.6.1 Quantities Obtained from a factory")
    @SpecAssertion(section="5.6.1", id="561-A1")
    public void testAccessToQuantityFactory() {
        Reflections reflections = new Reflections("javax.measure", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Quantity.class);
        for (Class clazz : subTypes) {
            QuantityFactory factory = ServiceProvider.current().getQuantityFactory(clazz);
            Assert.assertNotNull((Object)factory, (String)("Section 5.6.1: No QuantityFactory available for " + clazz.getSimpleName()));
        }
    }

    @Test(groups={"spi"}, description="5.6.1 Quantities obtained from a factory has create method")
    @SpecAssertion(section="5.6.1", id="561-A2")
    public void testAccessToQuantityFactoryCreate() {
        Reflections reflections = new Reflections("javax.measure", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Quantity.class);
        for (Class clazz : subTypes) {
            QuantityFactory factory = ServiceProvider.current().getQuantityFactory(clazz);
            TestUtils.testHasPublicMethod("Section 5.6.1", factory.getClass(), Quantity.class, "create", Number.class, Unit.class);
        }
    }

    @Test(groups={"spi"}, description="5.6.1 Quantities obtained from a factory has getSystemUnit method")
    @SpecAssertion(section="5.6.1", id="561-A3")
    public void testAccessToQuantityFactoryGetSystemUnit() {
        Reflections reflections = new Reflections("javax.measure", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Quantity.class);
        for (Class clazz : subTypes) {
            QuantityFactory factory = ServiceProvider.current().getQuantityFactory(clazz);
            TestUtils.testHasPublicMethod("Section 5.6.1", factory.getClass(), Unit.class, "getSystemUnit", new Class[0]);
        }
    }

    @Test(groups={"spi"}, description="5.6.1 Quantities obtained by string parsing")
    @SpecAssertion(section="5.6.1", id="561-A4")
    public void testGetQuantitiesFromString() {
        QuantityFormat format = ServiceProvider.current().getFormatService().getQuantityFormat();
        for (SystemOfUnits sou : ServiceProvider.current().getSystemOfUnitsService().getAvailableSystemsOfUnits()) {
            for (Unit u : sou.getUnits()) {
                Assert.assertNotNull((Object)u, (String)("Section 5.6.1: A Unit is missing from " + sou.getName()));
                if (u.getSymbol() == null) continue;
                String s = u.toString();
                Quantity q = format.parse((CharSequence)("1 " + s));
                Assert.assertEquals((Object)u, (Object)q.getUnit(), (String)("Section 5.6.1: Quantity unit could not be parsed for '" + s + "'"));
                Assert.assertEquals((double)1.0, (double)q.getValue().doubleValue(), (double)0.0, (String)("Section 5.6.1: Quantity value could not be parsed for '" + s + "'"));
            }
        }
    }
}

