/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.spi;

import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 385", version="2.2")
public class ObtainingUnitsTest {
    private static final String SECTION_NUM1 = "5.5.1";
    private static final String SECTION_NUM2 = "5.5.2";

    @Test(groups={"spi"}, description="5.5.1 Units Obtained from Unit Systems")
    @SpecAssertion(section="5.5.1", id="551-A1")
    public void testGetUnitsFromSystemOfUnits() {
        for (SystemOfUnits sou : ServiceProvider.current().getSystemOfUnitsService().getAvailableSystemsOfUnits()) {
            for (Unit u : sou.getUnits()) {
                Assert.assertNotNull((Object)u, (String)("Section 5.5.1: A Unit is missing from " + sou.getName()));
            }
        }
    }

    @Test(groups={"spi"}, description="5.5.2 Units Obtained by Symbol Parsing")
    @SpecAssertion(section="5.5.2", id="552-A1")
    public void testGetUnitsFromUnitString() {
        UnitFormat format = ServiceProvider.current().getFormatService().getUnitFormat();
        for (SystemOfUnits sou : ServiceProvider.current().getSystemOfUnitsService().getAvailableSystemsOfUnits()) {
            for (Unit u : sou.getUnits()) {
                Assert.assertNotNull((Object)u, (String)("Section 5.5.2: A Unit is missing from " + sou.getName()));
                if (u.getSymbol() == null) continue;
                String s = u.toString();
                Unit p = format.parse((CharSequence)s);
                Assert.assertEquals((Object)u, (Object)p, (String)("Section 5.5.2: Unit could not be parsed for '" + s + "'"));
            }
        }
    }
}

