/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.spi;

import java.util.List;
import javax.measure.spi.ServiceProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.number.OrderingComparison;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 385", version="2.2")
public class ServiceProviderTest {
    private static final String SECTION_NUM = "5.3";
    private static final String DESCRIPTION = "5.3 Service Provider";
    private static final String ASIN = ": available ServiceProviders is null";
    private static final String PRIO_VALID_INT = ": Priority should be a valid int";

    @Test(groups={"spi"}, description="5.3 Service Provider")
    @SpecAssertion(section="5.3", id="53-A1")
    public void testAvailable() {
        List spa = ServiceProvider.available();
        Assert.assertNotNull((Object)spa, (String)"Section 5.3: available ServiceProviders is null");
    }

    @Test(groups={"spi"}, description="5.3 Service Provider")
    @SpecAssertion(section="5.3", id="53-A2")
    public void testAvailableNotEmpty() {
        List spa = ServiceProvider.available();
        Assert.assertNotNull((Object)spa, (String)"Section 5.3: available ServiceProviders is null");
        MatcherAssert.assertThat((String)"Section 5.3: No available ServiceProviders found", (Object)spa, (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }

    @Test(groups={"spi"}, description="5.3 Service Provider")
    @SpecAssertion(section="5.3", id="53-A3")
    public void testCurrent() {
        ServiceProvider csp = ServiceProvider.current();
        Assert.assertNotNull((Object)csp, (String)"Section 5.3: No current ServiceProvider found");
    }

    @Test(groups={"spi"}, description="5.3 Service Provider")
    @SpecAssertion(section="5.3", id="53-A4")
    public void testPriority() {
        ServiceProvider csp = ServiceProvider.current();
        MatcherAssert.assertThat((String)"Section 5.3: Priority should be a valid int", (Object)csp.getPriority(), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(Integer.MIN_VALUE)));
        MatcherAssert.assertThat((String)"Section 5.3: Priority should be a valid int", (Object)csp.getPriority(), (Matcher)OrderingComparison.lessThanOrEqualTo((Comparable)Integer.valueOf(Integer.MAX_VALUE)));
    }
}

