/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.spi;

import java.util.Set;
import javax.measure.BinaryPrefix;
import javax.measure.MetricPrefix;
import javax.measure.spi.FormatService;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnitsService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 385", version="2.2")
public class ServicesTest {
    private static final String SECTION_NUM = "5.4";
    private static final String DESCRIPTION = "5.4 Services";
    private static final String AQFNAN = ": Available QuantityFormat names are null";
    private static final String AUFNAN = ": Available UnitFormat names are null";
    private static final String NAQFNF = ": No available QuantityFormat names found";
    private static final String NAUFNF = ": No available UnitFormat names found";

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A01")
    public void testFormatService() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            FormatService service = provider.getFormatService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: FormatService is null");
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A02")
    public void testFormatServiceQuantityFormatsAvailable() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            FormatService service = provider.getFormatService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: FormatService is null");
            Assert.assertNotNull((Object)service.getAvailableFormatNames(FormatService.FormatType.QUANTITY_FORMAT), (String)"Section 5.4: Available QuantityFormat names are null");
            MatcherAssert.assertThat((String)"Section 5.4: No available QuantityFormat names found", (Object)service.getAvailableFormatNames(FormatService.FormatType.QUANTITY_FORMAT), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A03")
    public void testFormatServiceQuantityFormatsDefault() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            FormatService service = provider.getFormatService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: FormatService is null");
            Assert.assertNotNull((Object)service.getUnitFormat(), (String)"Section 5.4: Default QuantityFormat is null");
            Assert.assertNotNull((Object)service.getAvailableFormatNames(FormatService.FormatType.QUANTITY_FORMAT), (String)"Section 5.4: Available QuantityFormat names are null");
            MatcherAssert.assertThat((String)"Section 5.4: No available QuantityFormat names found", (Object)service.getAvailableFormatNames(FormatService.FormatType.QUANTITY_FORMAT), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A04")
    public void testFormatServiceUnitFormatsAvailable() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            FormatService service = provider.getFormatService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: FormatService is null");
            Assert.assertNotNull((Object)service.getAvailableFormatNames(FormatService.FormatType.UNIT_FORMAT), (String)"Section 5.4: Available UnitFormat names are null");
            MatcherAssert.assertThat((String)"Section 5.4: No available UnitFormat names found", (Object)service.getAvailableFormatNames(FormatService.FormatType.UNIT_FORMAT), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A05")
    public void testFormatServiceUnitFormatsDefault() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            FormatService service = provider.getFormatService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: FormatService is null");
            Assert.assertNotNull((Object)service.getUnitFormat(), (String)"Section 5.4: Default UnitFormat is null");
            Assert.assertNotNull((Object)service.getAvailableFormatNames(FormatService.FormatType.UNIT_FORMAT), (String)"Section 5.4: Available UnitFormat names are null");
            MatcherAssert.assertThat((String)"Section 5.4: No available UnitFormat names found", (Object)service.getAvailableFormatNames(FormatService.FormatType.UNIT_FORMAT), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A06")
    public void testSystemOfUnitsService() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: SystemOfUnitsService is null");
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A07")
    public void testSystemOfUnitsServiceDefaultSystem() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: SystemOfUnitsService is null");
            Assert.assertNotNull((Object)service.getSystemOfUnits(), (String)"Section 5.4: Default SystemOfUnits is null");
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A08")
    public void testSystemOfUnitsServiceAvailableSystems() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: SystemOfUnitsService is null");
            Assert.assertNotNull((Object)service.getAvailableSystemsOfUnits(), (String)"Section 5.4: Available SystemOfUnits are null");
            MatcherAssert.assertThat((String)"Section 5.4 No available SystemOfUnits found", (Object)service.getAvailableSystemsOfUnits(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
        }
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A09")
    public void testSystemOfUnitsServicePrefixBinary() {
        ServiceProvider.available().forEach(provider -> {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: SystemOfUnitsService is null");
            Set prefixes = service.getPrefixes(BinaryPrefix.class);
            Assert.assertNotNull((Object)prefixes, (String)"Section 5.4: Binary Prefixes are null");
            MatcherAssert.assertThat((String)"Section 5.4 No Binary Prefixes found", (Object)prefixes, (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
            Assert.assertEquals((int)prefixes.size(), (int)8, (String)"Section 5.4 Wrong Number of Binary Prefixes");
        });
    }

    @Test(groups={"spi"}, description="5.4 Services")
    @SpecAssertion(section="5.4", id="54-A10")
    public void testSystemOfUnitsServicePrefixMetric() {
        ServiceProvider.available().forEach(provider -> {
            Assert.assertNotNull((Object)provider, (String)"Section 5.4: ServiceProvider is null");
            SystemOfUnitsService service = provider.getSystemOfUnitsService();
            Assert.assertNotNull((Object)service, (String)"Section 5.4: SystemOfUnitsService is null");
            Set prefixes = service.getPrefixes(MetricPrefix.class);
            Assert.assertNotNull((Object)prefixes, (String)"Section 5.4: Metric Prefixes are null");
            MatcherAssert.assertThat((String)"Section 5.4 No Metric Prefixes found", (Object)prefixes, (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
            Assert.assertEquals((int)prefixes.size(), (int)24, (String)"Section 5.4 Wrong Number of Metric Prefixes");
        });
    }
}

