/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.spi;

import java.util.Set;
import javax.measure.Dimension;
import javax.measure.Unit;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;
import tech.units.tck.util.TestUtils;

@SpecVersion(spec="JSR 385", version="2.2")
public class SystemOfUnitsTest {
    private static final String SECTION_NUM = "5.2";

    @Test(groups={"spi"}, description="5.2 Ensure a SystemOfUnits implementation exists for every ServiceProvider")
    @SpecAssertion(section="5.2", id="52-A1")
    public void testEnsureGotSystemOfUnits() {
        for (ServiceProvider provider : ServiceProvider.available()) {
            Assert.assertNotNull((Object)provider, (String)"Section 5.2: ServiceProvider is null");
            Assert.assertNotNull((Object)provider.getSystemOfUnitsService(), (String)String.format("SystemOfUnitsService is null for %s", provider));
            Assert.assertNotNull((Object)provider.getSystemOfUnitsService().getAvailableSystemsOfUnits(), (String)String.format("Available SystemOfUnits is null for %s", provider));
            MatcherAssert.assertThat((String)String.format("SystemOfUnits not found in %s", provider), (Object)provider.getSystemOfUnitsService().getAvailableSystemsOfUnits(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
        }
    }

    @Test(groups={"spi"}, description="5.2 Ensure the getName() method is implemented.")
    @SpecAssertion(section="5.2", id="52-A2")
    public void testSystemOfUnitsGetName() {
        for (SystemOfUnits suo : ServiceProvider.current().getSystemOfUnitsService().getAvailableSystemsOfUnits()) {
            Class<?> type = suo.getClass();
            TestUtils.testHasPublicMethod("Section 5.2", type, "getName");
        }
    }

    @Test(groups={"spi"}, description="5.2 Ensure the getUnit() method is implemented.")
    @SpecAssertion(section="5.2", id="52-A3")
    public void testSystemOfUnitsGetUnit() {
        for (SystemOfUnits suo : ServiceProvider.current().getSystemOfUnitsService().getAvailableSystemsOfUnits()) {
            Class<?> type = suo.getClass();
            TestUtils.testHasPublicMethod("Section 5.2", type, true, Unit.class, "getUnit", Class.class);
        }
    }

    @Test(groups={"spi"}, description="5.2 Ensure the getUnit() method is implemented.")
    @SpecAssertion(section="5.2", id="52-A4")
    public void testSystemOfUnitsGetUnitForString() {
        for (SystemOfUnits suo : ServiceProvider.current().getSystemOfUnitsService().getAvailableSystemsOfUnits()) {
            Class<?> type = suo.getClass();
            TestUtils.testHasPublicMethod("Section 5.2", type, true, Unit.class, "getUnit", String.class);
        }
    }

    @Test(groups={"spi"}, description="5.2 Ensure the getUnits() method is implemented.")
    @SpecAssertion(section="5.2", id="52-A5")
    public void testSystemOfUnitsGetUnits() {
        for (SystemOfUnits suo : ServiceProvider.current().getSystemOfUnitsService().getAvailableSystemsOfUnits()) {
            Class<?> type = suo.getClass();
            TestUtils.testHasPublicMethod("Section 5.2", type, "getUnits", false);
        }
    }

    @Test(groups={"spi"}, description="5.2 Ensure the getUnits() method is implemented.")
    @SpecAssertion(section="5.2", id="52-A6")
    public void testSystemOfUnitsGetUnitsForDimension() {
        for (SystemOfUnits suo : ServiceProvider.current().getSystemOfUnitsService().getAvailableSystemsOfUnits()) {
            Class<?> type = suo.getClass();
            TestUtils.testHasPublicMethod("Section 5.2", type, true, Set.class, "getUnits", Dimension.class);
        }
    }
}

